/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class FindBinding {
    public static PDOMBinding findBinding(BTree btree, PDOM pdom, char[] name, int[] constants, int localToFileRec) throws CoreException {
        DefaultFindBindingVisitor visitor = new DefaultFindBindingVisitor(pdom, name, constants, localToFileRec);
        btree.accept(visitor);
        return visitor.getResult();
    }

    public static PDOMBinding findBinding(IPDOMNode node, PDOM pdom, char[] name, int[] constants, int localToFileRec) throws CoreException {
        DefaultFindBindingVisitor visitor = new DefaultFindBindingVisitor(pdom, name, constants, localToFileRec);
        try {
            node.accept(visitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return visitor.getResult();
    }

    public static class DefaultBindingBTreeComparator
    implements IBTreeComparator {
        protected PDOM pdom;

        public DefaultBindingBTreeComparator(PDOM pdom) {
            this.pdom = pdom;
        }

        public int compare(int record1, int record2) throws CoreException {
            IString nm2;
            IString nm1 = PDOMNamedNode.getDBName(this.pdom, record1);
            int cmp = nm1.compareCompatibleWithIgnoreCase(nm2 = PDOMNamedNode.getDBName(this.pdom, record2));
            if (cmp == 0) {
                int t2;
                int t1 = PDOMBinding.getLocalToFileRec(this.pdom, record1);
                if (t1 == (t2 = PDOMBinding.getLocalToFileRec(this.pdom, record2))) {
                    t1 = PDOMNode.getNodeType(this.pdom, record1);
                    t2 = PDOMNode.getNodeType(this.pdom, record2);
                }
                cmp = t1 < t2 ? -1 : (t1 > t2 ? 1 : 0);
            }
            return cmp;
        }
    }

    public static class DefaultFindBindingVisitor
    implements IBTreeVisitor,
    IPDOMVisitor {
        protected final PDOM fPdom;
        private final char[] fName;
        private final int[] fConstants;
        private final int fLocalToFile;
        protected PDOMBinding fResult;

        protected DefaultFindBindingVisitor(PDOM pdom, char[] name, int[] constants, int localToFile) {
            this.fPdom = pdom;
            this.fName = name;
            this.fConstants = constants;
            this.fLocalToFile = localToFile;
        }

        public int compare(int record) throws CoreException {
            IString nm1 = PDOMNamedNode.getDBName(this.fPdom, record);
            int cmp = nm1.compareCompatibleWithIgnoreCase(this.fName);
            if (cmp == 0) {
                int t2;
                int t1 = PDOMBinding.getLocalToFileRec(this.fPdom, record);
                cmp = t1 < (t2 = this.fLocalToFile) ? -1 : (t1 > t2 ? 1 : 0);
            }
            return cmp;
        }

        public boolean visit(int record) throws CoreException {
            PDOMBinding binding;
            PDOMNamedNode nnode = (PDOMNamedNode)PDOMNode.getLinkage(this.fPdom, record).getNode(record);
            if (nnode instanceof PDOMBinding && this.matches(binding = (PDOMBinding)nnode)) {
                this.fResult = binding;
                return false;
            }
            return true;
        }

        protected boolean matches(PDOMBinding nnode) throws CoreException {
            if (nnode.hasName(this.fName)) {
                int constant = nnode.getNodeType();
                int i = 0;
                while (i < this.fConstants.length) {
                    if (constant == this.fConstants[i]) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public PDOMBinding getResult() {
            return this.fResult;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            PDOMBinding nnode;
            if (node instanceof PDOMBinding && this.matches(nnode = (PDOMBinding)node)) {
                this.fResult = nnode;
                throw new OperationCanceledException();
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }
    }

    public static class MacroBTreeComparator
    implements IBTreeComparator {
        private final PDOM fPDom;

        public MacroBTreeComparator(PDOM pdom) {
            this.fPDom = pdom;
        }

        public int compare(int record1, int record2) throws CoreException {
            return this.compare(PDOMNamedNode.getDBName(this.fPDom, record1), PDOMNamedNode.getDBName(this.fPDom, record2));
        }

        private int compare(IString nameInDB, IString nameInDB2) throws CoreException {
            return nameInDB.compareCompatibleWithIgnoreCase(nameInDB2);
        }
    }

    public static class NestedBindingsBTreeComparator
    extends DefaultBindingBTreeComparator {
        protected PDOMLinkage linkage;

        public NestedBindingsBTreeComparator(PDOMLinkage linkage) {
            super(linkage.pdom);
            this.linkage = linkage;
        }

        public int compare(int record1, int record2) throws CoreException {
            int cmp = super.compare(record1, record2);
            if (cmp == 0) {
                if (record1 < record2) {
                    return -1;
                }
                if (record1 > record2) {
                    return 1;
                }
            }
            return cmp;
        }
    }
}

