/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumeration;
import org.eclipse.core.runtime.CoreException;

class PDOMCEnumerator
extends PDOMBinding
implements IEnumerator {
    private static final int ENUMERATION = 28;
    private static final int NEXT_ENUMERATOR = 32;
    protected static final int RECORD_SIZE = 36;

    public PDOMCEnumerator(PDOM pdom, PDOMNode parent, IEnumerator enumerator, PDOMCEnumeration enumeration) throws CoreException {
        super(pdom, parent, enumerator.getNameCharArray());
        pdom.getDB().putInt(this.record + 28, enumeration.getRecord());
        enumeration.addEnumerator(this);
    }

    public PDOMCEnumerator(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 36;
    }

    public int getNodeType() {
        return 11;
    }

    public PDOMCEnumerator getNextEnumerator() throws CoreException {
        int value = this.pdom.getDB().getInt(this.record + 32);
        return value != 0 ? new PDOMCEnumerator(this.pdom, value) : null;
    }

    public void setNextEnumerator(PDOMCEnumerator enumerator) throws CoreException {
        int value = enumerator != null ? enumerator.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 32, value);
    }

    public IType getType() throws DOMException {
        try {
            return new PDOMCEnumeration(this.pdom, this.pdom.getDB().getInt(this.record + 28));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }
}

