/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;

public class CFunctionScope
extends CScope
implements ICFunctionScope {
    public CFunctionScope(IASTFunctionDefinition function) {
        super(function);
    }

    public IBinding getBinding(char[] name) {
        return super.getBinding(1, name);
    }

    public IScope getBodyScope() {
        IASTNode node = this.getPhysicalNode();
        IASTStatement statement = ((IASTFunctionDefinition)node).getBody();
        if (statement instanceof IASTCompoundStatement) {
            return ((IASTCompoundStatement)statement).getScope();
        }
        return null;
    }

    public ILabel[] getLabels() {
        FindLabelsAction action = new FindLabelsAction();
        this.getPhysicalNode().accept(action);
        Object[] result = null;
        if (action.labels != null) {
            int i = 0;
            while (i < action.labels.length && action.labels[i] != null) {
                IASTLabelStatement labelStatement = action.labels[i];
                IBinding binding = labelStatement.getName().resolveBinding();
                if (binding != null) {
                    result = (ILabel[])ArrayUtil.append(ILabel.class, result, binding);
                }
                ++i;
            }
        }
        return (ILabel[])ArrayUtil.trim(ILabel.class, result);
    }

    private static class FindLabelsAction
    extends CASTVisitor {
        public IASTLabelStatement[] labels = null;

        public FindLabelsAction() {
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTLabelStatement) {
                this.labels = (IASTLabelStatement[])ArrayUtil.append(IASTLabelStatement.class, this.labels, statement);
            }
            return 3;
        }
    }
}

