/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;

public class CPPFunctionType
implements ICPPFunctionType {
    private IType[] parameters;
    private IType returnType;
    private IPointerType thisType;

    public CPPFunctionType(IType returnType, IType[] types) {
        this.returnType = returnType;
        this.parameters = types;
    }

    public CPPFunctionType(IType returnType, IType[] types, IPointerType thisType) {
        this.returnType = returnType;
        this.parameters = types;
        this.thisType = thisType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameType(IType o) {
        IType[] fps;
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof ICPPFunctionType)) {
            return false;
        }
        ICPPFunctionType ft = (ICPPFunctionType)o;
        try {
            fps = ft.getParameterTypes();
        }
        catch (DOMException dOMException) {
            return false;
        }
        try {
            if (this.returnType == null ^ ft.getReturnType() == null) {
                return false;
            }
            if (this.returnType != null && !this.returnType.isSameType(ft.getReturnType())) {
                return false;
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        try {
            if (this.parameters.length == 1 && fps.length == 0) {
                if (this.parameters[0] instanceof IBasicType && ((IBasicType)this.parameters[0]).getType() == 1) return this.isConst() == ft.isConst() && this.isVolatile() == ft.isVolatile();
                return false;
            }
            if (fps.length == 1 && this.parameters.length == 0) {
                if (fps[0] instanceof IBasicType && ((IBasicType)fps[0]).getType() == 1) return this.isConst() == ft.isConst() && this.isVolatile() == ft.isVolatile();
                return false;
            } else {
                if (this.parameters.length != fps.length) {
                    return false;
                }
                int i = 0;
                while (i < this.parameters.length) {
                    if (this.parameters[i] == null || !this.parameters[i].isSameType(fps[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return this.isConst() == ft.isConst() && this.isVolatile() == ft.isVolatile();
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public IType[] getParameterTypes() {
        return this.parameters;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public IPointerType getThisType() {
        return this.thisType;
    }

    public final boolean isConst() {
        return this.thisType != null && this.thisType.isConst();
    }

    public final boolean isVolatile() {
        return this.thisType != null && this.thisType.isVolatile();
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

