/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.wizard.EnvironmentWizard;
import org.eclipse.swt.widgets.Shell;

public class RemoteToolsUIConnectionManager
implements IRemoteUIConnectionManager {
    private TargetTypeElement remoteHost = null;
    private IRemoteConnectionManager connMgr = null;

    public RemoteToolsUIConnectionManager(IRemoteServices services) {
        this.connMgr = services.getConnectionManager();
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        for (Object obj : targetMgr.getTypeElements()) {
            TargetTypeElement element = (TargetTypeElement)obj;
            if (!element.getName().equals("Remote Host")) continue;
            this.remoteHost = element;
            break;
        }
    }

    public IRemoteConnection newConnection(Shell shell) {
        if (this.remoteHost != null) {
            IRemoteConnection[] oldConns = this.connMgr.getConnections();
            EnvironmentWizard wizard = new EnvironmentWizard(this.remoteHost);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                IRemoteConnection[] newConns = this.connMgr.getConnections();
                if (newConns.length <= oldConns.length) {
                    return null;
                }
                Arrays.sort(oldConns, new Comparator<IRemoteConnection>(){

                    @Override
                    public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                        return c1.getName().compareToIgnoreCase(c2.getName());
                    }
                });
                Arrays.sort(newConns, new Comparator<IRemoteConnection>(){

                    @Override
                    public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                        return c1.getName().compareToIgnoreCase(c2.getName());
                    }
                });
                int i = 0;
                while (i < oldConns.length) {
                    if (!oldConns[i].equals(newConns[i])) {
                        return newConns[i];
                    }
                    ++i;
                }
                return newConns[newConns.length - 1];
            }
        }
        return null;
    }
}

