/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.debug;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.utils.debug.Messages;
import org.osgi.framework.Bundle;

public class DebugPolicy {
    private static final String UNKNOWN_METHOD_STR = "unknown method";
    private static final String DEBUG_OPTION_INCLUDE_ID = "trace/id";
    private static final String DEBUG_OPTION_INCLUDE_THREADID = "trace/thread";
    private static final String DEBUG_OPTION_INCLUDE_TIMESTAMP = "trace/timestamp";
    private static final String DEBUG_OOPTION_DYNAMIC_TRACE = "trace/dynamic";
    private static final String DEBUG_OOPTION_MASTER = "debug";
    private static final String EMPTY_STRING_STR = "<empty string>";
    private static final String NULL_STR = "<null>";
    public static final String TRUE = Boolean.TRUE.toString();
    public static final String FALSE = Boolean.FALSE.toString();
    String pluginId = null;
    boolean hasReadOptions = false;
    boolean isDynamic = false;
    String traceId = null;
    boolean showTimeStamp = false;
    boolean showThreadId = false;
    Set<String> knownDebugProperties = new HashSet<String>();
    public boolean DEBUG = false;

    public DebugPolicy(String pluginId) {
        this.pluginId = pluginId;
        if (Platform.inDebugMode()) {
            try {
                this.trace("Trace framework for {0} loaded", pluginId);
                Bundle bundle = Platform.getBundle((String)pluginId);
                Path path = new Path("/.options");
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                if (url == null) {
                    throw new IOException("FileLocator.find() returned null");
                }
                InputStream is = url.openStream();
                if (is == null) {
                    throw new IOException("InputStream is null");
                }
                Properties properties = new Properties();
                properties.load(is);
                Enumeration<Object> en = properties.keys();
                while (en.hasMoreElements()) {
                    String elem = (String)en.nextElement();
                    this.knownDebugProperties.add(elem);
                }
            }
            catch (Exception e) {
                this.error("Could not load .options file: {0}", e.getMessage());
                this.logError(e, Messages.DebugPolicy_FailedOptionsFile, pluginId);
            }
        }
    }

    public String getStringOption(String id) {
        String option = String.valueOf(this.pluginId) + "/" + id;
        if (Platform.inDebugMode() && !this.knownDebugProperties.contains(option)) {
            this.error("Unknown debug option: {0}", option);
            this.logError(Messages.DebugPolicy_UnknownDebugOptions, option);
        }
        String result = Platform.getDebugOption((String)option);
        return result;
    }

    public boolean getBooleanOption(String id) {
        return TRUE.equalsIgnoreCase(this.getStringOption(id));
    }

    public boolean read() {
        if (this.isDynamic || !this.hasReadOptions) {
            boolean inDebug = Platform.inDebugMode();
            this.DEBUG = inDebug && this.getBooleanOption(DEBUG_OOPTION_MASTER);
            this.isDynamic = this.getBooleanOption(DEBUG_OOPTION_DYNAMIC_TRACE);
            this.showTimeStamp = this.getBooleanOption(DEBUG_OPTION_INCLUDE_TIMESTAMP);
            this.showThreadId = this.getBooleanOption(DEBUG_OPTION_INCLUDE_THREADID);
            this.traceId = this.getStringOption(DEBUG_OPTION_INCLUDE_ID);
            if (this.traceId == null) {
                this.traceId = this.pluginId;
            }
            this.hasReadOptions = true;
            return true;
        }
        return false;
    }

    public void trace(String pattern, Object ... arguments) {
        this.trace(MessageFormat.format(pattern, arguments));
    }

    public void trace(boolean option, String pattern, Object ... arguments) {
        this.trace(option, MessageFormat.format(pattern, arguments));
    }

    public void trace(String message) {
        if (this.traceId != null) {
            System.out.print(this.traceId);
        }
        if (this.showTimeStamp) {
            System.out.print(" " + Long.toString(System.currentTimeMillis()));
        }
        if (this.showThreadId) {
            String name = Thread.currentThread().getName();
            if (name == null) {
                name = Long.toString(Thread.currentThread().getId());
            }
            System.out.print(" " + name);
        }
        if (this.traceId != null || this.showThreadId || this.showTimeStamp) {
            System.out.print(": ");
        }
        System.out.println(message);
        System.out.flush();
    }

    public void trace(boolean option, String message) {
        if (option) {
            this.trace(message);
        }
    }

    public void error(String pattern, Object ... arguments) {
        this.error(MessageFormat.format(pattern, arguments));
    }

    public void error(boolean option, String pattern, Object ... arguments) {
        this.error(option, MessageFormat.format(pattern, arguments));
    }

    public void error(String message) {
        System.out.print("(!) ");
        this.trace(message);
    }

    public void error(boolean option, String message) {
        if (option) {
            this.error(message);
        }
    }

    public void error(Throwable e) {
        this.error("Unexpected exception: " + e.getMessage());
    }

    public void error(boolean option, Throwable e) {
        if (option) {
            this.error(e);
        }
    }

    public void enter() {
        StackTraceElement trace = this.getStackTraceElement();
        String functionName = this.getMethodName(trace);
        this.trace("(=>) " + functionName + "()");
    }

    public void enter(Object ... parameters) {
        StackTraceElement trace = this.getStackTraceElement();
        String functionName = this.getMethodName(trace);
        String parameterList = this.getParameterList(parameters);
        this.trace("(=>) " + functionName + "(" + parameterList + ")");
    }

    public void enter(boolean option, Object ... parameters) {
        if (option) {
            this.enter(parameters);
        }
    }

    public void enter(boolean option) {
        if (option) {
            this.enter();
        }
    }

    public void exit() {
        StackTraceElement trace = this.getStackTraceElement();
        String functionName = this.getMethodName(trace);
        this.trace("(<=) " + functionName);
    }

    public void exit(Object returnValue) {
        StackTraceElement trace = this.getStackTraceElement();
        String functionName = this.getMethodName(trace);
        String returnString = this.getReturnString(returnValue);
        this.trace("(<=) " + functionName + ": " + returnString);
    }

    public void exit(boolean option, Object returnValue) {
        if (option) {
            this.exit(returnValue);
        }
    }

    public void exit(boolean option) {
        if (option) {
            this.exit();
        }
    }

    public void exit(boolean option, String string, Object ... params) {
        if (option) {
            this.exit(string, params);
        }
    }

    public void exit(String string, Object[] params) {
        this.exit(MessageFormat.format(string, params));
    }

    public void pass(boolean option) {
        if (option) {
            this.pass();
        }
    }

    public void pass() {
        StackTraceElement trace = this.getStackTraceElement();
        String functionName = this.getMethodName(trace);
        this.trace("(==) " + functionName);
    }

    public void pass(boolean option, Object ... parameters) {
        if (option) {
            this.pass();
        }
    }

    public void pass(Object ... parameters) {
        this.pass(this.getParameterList(parameters), new Object[0]);
    }

    public void pass(boolean option, String pattern, Object ... parameters) {
        if (option) {
            this.pass(pattern, parameters);
        }
    }

    public void pass(String pattern, Object ... parameters) {
        this.pass(MessageFormat.format(pattern, parameters), new Object[0]);
    }

    private String getReturnString(Object returnValue) {
        String returnString = null;
        if (returnValue == null) {
            returnString = NULL_STR;
        } else {
            returnString = returnValue.toString();
            if (returnString.length() == 0) {
                returnString = EMPTY_STRING_STR;
            }
        }
        return returnString;
    }

    private String getMethodName(StackTraceElement trace) {
        if (trace == null) {
            return UNKNOWN_METHOD_STR;
        }
        return String.valueOf(trace.getClassName()) + "." + trace.getMethodName();
    }

    private String getParameterList(Object ... parameters) {
        String parameterList = "";
        int i = 0;
        while (i < parameters.length) {
            String p = null;
            p = parameters[i] == null ? NULL_STR : parameters[i].toString();
            if (i > 0) {
                parameterList = String.valueOf(parameterList) + ", ";
            }
            parameterList = String.valueOf(parameterList) + p;
            ++i;
        }
        return parameterList;
    }

    private StackTraceElement getStackTraceElement() {
        Throwable t = new Throwable();
        StackTraceElement[] stack = t.getStackTrace();
        if (stack == null) {
            return null;
        }
        if (stack.length == 0) {
            return null;
        }
        int index = 0;
        while (index < stack.length && stack[index].getClassName().equals(DebugPolicy.class.getName())) {
            ++index;
        }
        if (index >= stack.length) {
            return stack[stack.length - 1];
        }
        return stack[index];
    }

    public void logStatus(IStatus status) {
        try {
            Bundle bundle = Platform.getBundle((String)this.pluginId);
            ILog log = Platform.getLog((Bundle)bundle);
            log.log(status);
        }
        catch (Exception e) {
            System.err.println(Messages.DebugPolicy_FailedLogStatus);
            System.err.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
    }

    public void logError(Throwable exception, String message, Object ... parameters) {
        this.logStatus((IStatus)new Status(4, this.pluginId, 0, MessageFormat.format(message, parameters), exception));
    }

    public void logError(String message, Object ... parameters) {
        this.logError(null, message, parameters);
    }

    public void logError(Throwable e) {
        if (e instanceof CoreException) {
            CoreException coreException = (CoreException)e;
            this.logStatus(coreException.getStatus());
        } else {
            this.logError(e, Messages.DebugPolicy_InternalErrorMessage, new Object[0]);
        }
    }
}

