/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.terminal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.terminal.ITerminalProvider;
import org.eclipse.ptp.cell.utils.terminal.ITerminalReceiver;
import org.eclipse.ptp.cell.utils.terminal.Messages;

public abstract class AbstractTerminalProvider
implements ITerminalProvider {
    Collection terminalReceivers = new HashSet();

    public void addListener(ITerminalReceiver receiver) {
        this.terminalReceivers.add(receiver);
    }

    public void removeListener(ITerminalReceiver receiver) {
        this.terminalReceivers.remove(receiver);
    }

    public void receiveMetaMessage(String message) {
        for (ITerminalReceiver listener : this.terminalReceivers) {
            try {
                listener.receiveMetaMessage(message);
            }
            catch (Exception ee) {
                Debug.POLICY.error(Debug.DEBUG_STREAM, ee);
                Debug.POLICY.logError(ee, Messages.AbstractTerminalProvider_FailedDelegateMethod, new Object[0]);
            }
        }
    }

    public void receiveDataFromTerminal(byte[] bytes, int length) {
        for (ITerminalReceiver listener : this.terminalReceivers) {
            try {
                listener.receiveData(bytes, length);
            }
            catch (Exception ee) {
                Debug.POLICY.error(Debug.DEBUG_STREAM, ee);
                Debug.POLICY.logError(ee, Messages.AbstractTerminalProvider_1, new Object[0]);
            }
        }
    }

    public void receiveErrorFromTerminal(byte[] bytes, int length) {
        for (ITerminalReceiver listener : this.terminalReceivers) {
            try {
                listener.receiveError(bytes, length);
            }
            catch (Exception ee) {
                Debug.POLICY.error(Debug.DEBUG_STREAM, ee);
                Debug.POLICY.logError(ee, Messages.AbstractTerminalProvider_2, new Object[0]);
            }
        }
    }

    public abstract void writeDataToTerminal(byte[] var1, int var2);
}

