/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.cell.sputiming.ui.parse.InstructionLine;
import org.eclipse.ptp.cell.sputiming.ui.parse.ParsedTimingFile;
import org.eclipse.ptp.cell.sputiming.ui.parse.TimingFileLine;
import org.eclipse.ptp.cell.sputiming.ui.views.DiagramBar;
import org.eclipse.ptp.cell.sputiming.ui.views.DiagramVector;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TimeDiagram
extends Composite {
    private static int NOPE = 0;
    private static int BAR = 1;
    private static int TEXT = 2;
    private Color LINE_NUMBER_COLOR = new Color(null, 70, 70, 70);
    private GridLayout gridLayout;
    private int componentWidth = 0;
    private int componentHeight = 0;
    private int stepSize = 10;
    private int maxTime = 0;
    private int barHeight = 23;
    private List lineNumberLabels = new ArrayList();
    private List instructionLabels = new ArrayList();
    private int widestLineNumberLabel = 0;
    private int widestInstructionLabel = 0;

    public TimeDiagram(Composite parent, ParsedTimingFile timingFile) {
        super(parent, 0);
        this.maxTime = timingFile.getMaxTime();
        this.init(timingFile);
    }

    private void init(ParsedTimingFile timingFile) {
        this.gridLayout = new GridLayout(3, false);
        this.gridLayout.marginWidth = 0;
        this.gridLayout.marginHeight = 0;
        this.gridLayout.verticalSpacing = 0;
        this.gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)this.gridLayout);
        this.buildBars(timingFile);
    }

    private void buildBars(ParsedTimingFile timingFile) {
        int lineCount = 0;
        for (TimingFileLine line : timingFile.getLineVector()) {
            if (!(line instanceof InstructionLine)) continue;
            InstructionLine instructionLine = (InstructionLine)line;
            this.buildInstructionBar(++lineCount, instructionLine.getLineNumber(), instructionLine.getInstruction(), instructionLine.getParallelInfo(), instructionLine.getTimeInfo().getPosition(), instructionLine.getTimeInfo().getNopesCount(), instructionLine.getTimeInfo().getInstructionSize(), instructionLine.getPipelineNumber());
        }
        this.pack();
        this.processLabels();
    }

    private void buildNonInstructionBlock(int lineCount, int lineNumber, String line) {
        Color lineBackground = this.getBackgroundColor(lineCount);
        this.createLineLabel(lineNumber, lineBackground);
        CLabel nonInstructionLabel = new CLabel((Composite)this, 131072);
        nonInstructionLabel.setText(line);
        nonInstructionLabel.setForeground(this.LINE_NUMBER_COLOR);
        nonInstructionLabel.setBackground(lineBackground);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        nonInstructionLabel.setLayoutData((Object)gridData);
        this.componentHeight += this.barHeight;
    }

    private void processLabels() {
        this.widestLineNumberLabel = this.getTheWidestCLabel(this.lineNumberLabels);
        this.widestInstructionLabel = this.getTheWidestCLabel(this.instructionLabels);
    }

    private int getTheWidestCLabel(List labelsList) {
        int widestLabel = 0;
        for (CLabel currentLabel : labelsList) {
            int currentWidth = currentLabel.getSize().x;
            if (currentWidth <= widestLabel) continue;
            widestLabel = currentWidth;
        }
        return widestLabel;
    }

    private void buildInstructionBar(int lineCount, int lineNumber, String instruction, int parallelInfo, int initial, int nopeSize, int size, int colorIndex) {
        Color lineBackground = this.getBackgroundColor(lineCount);
        this.createLineLabel(lineNumber, lineBackground);
        CLabel instructionLabel = new CLabel((Composite)this, 16384);
        instructionLabel.setText(instruction);
        Font currentFont = new Font(null, "arial", 10, 0);
        if (parallelInfo == InstructionLine.COULDBE) {
            currentFont = new Font(null, "arial", 10, 2);
        } else if (parallelInfo == InstructionLine.YES) {
            currentFont = new Font(null, "arial", 10, 1);
        }
        instructionLabel.setFont(currentFont);
        instructionLabel.setForeground(this.getColorByIndex(colorIndex, TEXT));
        instructionLabel.setBackground(lineBackground);
        instructionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.instructionLabels.add(instructionLabel);
        DiagramVector dVector = new DiagramVector();
        if (nopeSize > 0) {
            dVector.addBlock(initial, nopeSize, this.getColorByIndex(colorIndex, NOPE));
            dVector.addBlock(initial + nopeSize, size, this.getColorByIndex(colorIndex, BAR));
        } else {
            dVector.addBlock(initial, size, this.getColorByIndex(colorIndex, BAR));
        }
        DiagramBar bar = new DiagramBar(this, lineBackground, this.maxTime, this.barHeight, this.maxTime * this.stepSize);
        bar.setDiagramVector(dVector);
        if (this.componentWidth < bar.getSize().x) {
            this.componentWidth = bar.getSize().x;
        }
        this.componentHeight += bar.getSize().y;
    }

    private void createLineLabel(int lineNumber, Color lineBackground) {
        CLabel lineLabel = new CLabel((Composite)this, 131072);
        lineLabel.setForeground(this.LINE_NUMBER_COLOR);
        lineLabel.setBackground(lineBackground);
        lineLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        lineLabel.setText(Integer.toString(lineNumber));
        this.lineNumberLabels.add(lineLabel);
    }

    private Color getBackgroundColor(int lineCount) {
        if (lineCount % 2 == 0) {
            return new Color(null, 175, 175, 175);
        }
        return new Color(null, 185, 185, 185);
    }

    private Color getColorByIndex(int colorIndex, int type) {
        if (type == NOPE) {
            if (colorIndex == 0) {
                return new Color(null, 150, 150, 200);
            }
            if (colorIndex == 1) {
                return new Color(null, 150, 200, 150);
            }
        } else if (type == BAR) {
            if (colorIndex == 0) {
                return new Color(null, 0, 0, 200);
            }
            if (colorIndex == 1) {
                return new Color(null, 0, 200, 0);
            }
        } else if (type == TEXT) {
            if (colorIndex == 0) {
                return new Color(null, 0, 0, 130);
            }
            if (colorIndex == 1) {
                return new Color(null, 0, 130, 0);
            }
        }
        return new Color(null, 255, 10, 10);
    }

    public Point getSize() {
        return new Point(this.widestLineNumberLabel + this.widestInstructionLabel + this.componentWidth, this.componentHeight);
    }
}

