/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.control;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.AuthToken;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.KeyAuthToken;
import org.eclipse.ptp.remotetools.core.PasswdAuthToken;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetControlJobListener;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.environment.control.TargetControlledJob;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

public abstract class SSHTargetControl
implements ITargetControl {
    private Map remoteJobs;
    private IRemoteConnection remoteConnection;
    private Set jobListeners = new HashSet();
    private CoreException pendingException = null;
    SSHParameters sshParameters;

    public static Map getCipherTypesMap() {
        HashMap cipherTypesMap = new HashMap(RemotetoolsPlugin.getCipherTypesMap());
        return cipherTypesMap;
    }

    protected synchronized void throwPendingException() throws CoreException {
        if (this.pendingException != null) {
            throw this.pendingException;
        }
    }

    protected synchronized void notifyException(CoreException e) {
        this.pendingException = e;
    }

    public synchronized void addJobListener(ITargetControlJobListener listener) {
        this.jobListeners.add(listener);
    }

    public synchronized void removeJobListener(ITargetControlJobListener listener) {
        this.jobListeners.remove(listener);
    }

    public synchronized void startJob(ITargetJob job) throws CoreException {
        if (this.query() != 3 && this.query() != 2) {
            throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, "Target not ready to execute jobs", null));
        }
        TargetControlledJob controlledJob = new TargetControlledJob(this, job);
        this.remoteJobs.put(job, controlledJob);
        controlledJob.start();
    }

    protected synchronized void notifyStartingJob(ITargetJob job) {
        for (ITargetControlJobListener listener : this.jobListeners) {
            listener.beforeJobStart(job);
        }
        try {
            this.resume(null);
        }
        catch (CoreException coreException) {}
    }

    protected synchronized void notifyFinishedJob(ITargetJob job) {
        for (ITargetControlJobListener listener : this.jobListeners) {
            listener.afterJobFinish(job);
        }
        if (this.remoteJobs == null) {
            return;
        }
        this.remoteJobs.remove(job);
    }

    public synchronized int getJobCount() {
        return this.remoteJobs.size();
    }

    public synchronized ITargetJob[] getJobs() {
        ITargetJob[] array = new ITargetJob[this.remoteJobs.size()];
        this.remoteJobs.keySet().toArray(array);
        return array;
    }

    protected synchronized void setConnectionParameters(SSHParameters parameters) {
        this.sshParameters = parameters;
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)this.sshParameters, (String)"missing ssh parameters");
        while (true) {
            try {
                if (monitor.isCanceled()) {
                    this.disconnect();
                    throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, "Connection to target canceled", null));
                }
                this.connect();
                if (monitor.isCanceled()) {
                    this.disconnect();
                    throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, "Connection to target canceled", null));
                }
                return true;
            }
            catch (RemoteConnectionException e) {
                monitor.subTask("Failed: " + e.getMessage());
                this.disconnect();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    this.disconnect();
                    throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, "Connection to target canceled", null));
                }
            }
        }
    }

    protected synchronized void connect() throws RemoteConnectionException {
        Assert.isNotNull((Object)this.sshParameters, (String)"missing ssh parameters");
        Object authToken = this.sshParameters.isPasswdAuth ? new PasswdAuthToken(this.sshParameters.user, this.sshParameters.password) : new KeyAuthToken(this.sshParameters.user, new File(this.sshParameters.keyPath), this.sshParameters.passphrase);
        try {
            this.remoteConnection = this.sshParameters.timeout <= 0 ? RemotetoolsPlugin.createSSHConnection((AuthToken)authToken, (String)this.sshParameters.hostname, (int)this.sshParameters.port, (String)this.sshParameters.cipherType) : RemotetoolsPlugin.createSSHConnection((AuthToken)authToken, (String)this.sshParameters.hostname, (int)this.sshParameters.port, (String)this.sshParameters.cipherType, (int)this.sshParameters.timeout);
            this.remoteConnection.connect();
            this.remoteJobs = new HashMap();
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            throw e;
        }
    }

    protected abstract String getPluginId();

    public boolean kill(IProgressMonitor monitor) throws CoreException {
        try {
            this.terminateJobs(monitor);
        }
        finally {
            this.disconnect();
        }
        this.remoteConnection = null;
        return true;
    }

    public boolean executeRemoteCommand(IProgressMonitor monitor, String command, String[] args) throws CoreException {
        int i = 0;
        while (i < args.length) {
            command = String.valueOf(command) + " " + args[i];
            ++i;
        }
        try {
            IRemoteExecutionManager executionManager = this.remoteConnection.createRemoteExecutionManager();
            executionManager.getExecutionTools().executeWithExitValue(command);
            executionManager.close();
            return true;
        }
        catch (RemoteConnectionException e) {
            throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, "Failed to connect with remote target environment", (Throwable)e));
        }
        catch (CancelException e) {
            throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, "Cancelled execution on remote target environment", (Throwable)e));
        }
        catch (RemoteExecutionException e) {
            throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, "Failed to execute on remote target environment", (Throwable)e));
        }
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) throws CoreException {
        ITargetControl.TargetSocket test = new ITargetControl.TargetSocket();
        test.host = "localhost";
        test.port = port;
        return test;
    }

    protected boolean isConnected() {
        return this.remoteConnection != null && this.remoteConnection.isConnected();
    }

    protected synchronized void terminateJobs(IProgressMonitor monitor) {
        for (ITargetJob job : this.remoteJobs.keySet()) {
            TargetControlledJob controlledJob = (TargetControlledJob)this.remoteJobs.get(job);
            controlledJob.cancelExecution();
        }
        while (this.getJobCount() > 0) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return;
        }
    }

    protected synchronized void disconnect() {
        if (this.remoteJobs != null) {
            this.remoteJobs.clear();
            this.remoteJobs = null;
        }
        if (this.remoteConnection != null) {
            this.remoteConnection.disconnect();
            this.remoteConnection = null;
        }
    }

    protected IRemoteExecutionManager createRemoteExecutionManager() throws RemoteConnectionException {
        return this.remoteConnection.createRemoteExecutionManager();
    }

    public IRemoteConnection getConnection() {
        Assert.isTrue((boolean)false, (String)"this method is not supported");
        return this.remoteConnection;
    }

    protected class SSHParameters {
        public String hostname;
        public int port;
        public String user;
        public String password;
        public String keyPath;
        public String passphrase;
        public boolean isPasswdAuth;
        public String cipherType;
        public int timeout = 0;

        public SSHParameters(String hostname, int port, String user, String password) {
            this(hostname, port, user, password, RemotetoolsPlugin.CIPHER_DEFAULT, 0);
        }

        public SSHParameters(String hostname, int port, String user, String password, String cipherType, int timeout) {
            this.hostname = hostname;
            this.port = port;
            this.user = user;
            this.password = password;
            this.timeout = timeout;
            this.cipherType = cipherType;
            this.isPasswdAuth = true;
        }

        public SSHParameters(String hostname, int port, String user, String keyPath, String passphrase, String cipherType, int timeout) {
            this.hostname = hostname;
            this.port = port;
            this.user = user;
            this.keyPath = keyPath;
            this.passphrase = passphrase;
            this.timeout = timeout;
            this.cipherType = cipherType;
            this.isPasswdAuth = false;
        }

        public SSHParameters(String hostname, int port, String user, String keyPath, String passphrase) {
            this(hostname, port, user, keyPath, passphrase, RemotetoolsPlugin.CIPHER_DEFAULT, 0);
        }
    }
}

