/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ptp.cell.simulator.conf.Parameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorDelegate;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

public abstract class AbstractSimulatorDelegate
implements ISimulatorDelegate {
    ISimulatorParameters configuration;

    public AbstractSimulatorDelegate(ISimulatorParameters configuration) {
        this.configuration = configuration;
    }

    public ISimulatorParameters getConfiguration() {
        return this.configuration;
    }

    protected String[] toVariablesArray(Map env) {
        Iterator iterator = env.entrySet().iterator();
        String[] strings = new String[env.size()];
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            strings[i] = entry.getKey() + "=" + entry.getValue();
            ++i;
        }
        return strings;
    }

    protected void addDefaultVariables(Map env) {
        env.put("SYSTEMSIM_TOP", this.configuration.getSimulatorBaseDirectory());
        if (this.configuration.getArchitectureTclString() != null) {
            env.put("CELL_CPU_CONFIG", this.configuration.getArchitectureTclString());
        }
        if (this.configuration.doMemorySize()) {
            env.put("CELL_MEMORY_SIZE", Integer.toString(this.configuration.getMemorySize()));
        }
        if (this.configuration.getKernelImagePath() != null) {
            env.put("CELL_KERNEL_IMAGE", this.configuration.getKernelImagePath());
        }
        if (this.configuration.getRootImagePath() != null) {
            env.put("CELL_ROOT_IMAGE", this.configuration.getRootImagePath());
        }
        if (this.configuration.getRootImagePersistence() == 1) {
            env.put("CELL_ROOT_PERSISTENCE", "discard");
        } else if (this.configuration.getRootImagePersistence() == 2) {
            env.put("CELL_ROOT_PERSISTENCE", "write");
        } else if (this.configuration.getRootImagePersistence() == 3) {
            env.put("CELL_ROOT_PERSISTENCE", "journal");
            if (this.configuration.getRootImageJournalPath() != null) {
                env.put("CELL_ROOT_JOURNAL", this.configuration.getRootImageJournalPath());
            }
        }
        if (this.configuration.doMountExtraImage() && this.configuration.getExtraImagePath() != null) {
            env.put("CELL_EXTRA_IMAGE", this.configuration.getExtraImagePath());
            if (this.configuration.getExtraImagePersistence() == 1) {
                env.put("CELL_EXTRA_PERSISTENCE", "discard");
            } else if (this.configuration.getExtraImagePersistence() == 2) {
                env.put("CELL_EXTRA_PERSISTENCE", "write");
            } else if (this.configuration.getExtraImagePersistence() == 3) {
                env.put("CELL_EXTRA_PERSISTENCE", "journal");
                if (this.configuration.getExtraImageJournalPath() != null) {
                    env.put("CELL_EXTRA_JOURNAL", this.configuration.getExtraImageJournalPath());
                }
            }
            if (this.configuration.getExtraImageMountPoint() != null) {
                env.put("CELL_EXTRA_MOUNTPOINT", this.configuration.getExtraImageMountPoint());
            }
            if (this.configuration.getExtraImageType() != null) {
                env.put("CELL_EXTRA_TYPE", this.configuration.getExtraImageType());
            }
        }
        if (this.configuration.doNetworkInit()) {
            env.put("CELL_NET_INIT", "true");
            if (this.configuration.getIpHost() != null) {
                env.put("CELL_NET_IP_HOST", this.configuration.getIpHost());
            }
            if (this.configuration.getIpSimulator() != null) {
                env.put("CELL_NET_IP_SIMULATOR", this.configuration.getIpSimulator());
            }
            if (this.configuration.getMacSimulator() != null) {
                env.put("CELL_NET_MAC_SIMULATOR", this.configuration.getMacSimulator());
            }
            if (this.configuration.getNetmaskSimulator() != null) {
                env.put("CELL_NET_MASK", this.configuration.getNetmaskSimulator());
            }
            if (this.configuration.doSshInit()) {
                env.put("CELL_SSH_INIT", "true");
            } else {
                env.put("CELL_SSH_INIT", "false");
            }
        } else {
            env.put("CELL_NET_INIT", "false");
        }
        if (this.configuration.doConsoleSocketInit()) {
            env.put("CELL_CONSOLE_PORT", Integer.toString(this.configuration.getConsolePort()));
        }
        if (this.configuration.doConsoleEcho()) {
            env.put("CELL_CONSOLE_ECHO", "true");
        } else {
            env.put("CELL_CONSOLE_ECHO", "false");
        }
        if (this.configuration.getConsoleCommands() != null) {
            env.put("CELL_CONSOLE_COMMANDS", this.configuration.getConsoleCommands());
        }
    }

    public String[] createCommandLine() throws SimulatorException {
        Vector<String> commandVector = new Vector<String>();
        commandVector.add(this.configuration.getSimulatorExecutable());
        if (this.configuration.doShowSimulatorGUI()) {
            commandVector.add("-g");
        }
        commandVector.add("-f");
        commandVector.add(this.configuration.getTclScriptName());
        if (this.configuration.doJavaApiSocketInit() && Parameters.doUseJavaAPI()) {
            commandVector.add("-s");
            commandVector.add(Integer.toString(this.configuration.getJavaApiPort()));
        }
        if (!this.configuration.doConsoleTerminalInit()) {
            commandVector.add("-n");
        }
        if (this.configuration.getExtraCommandLineSwitches() != null) {
            ArgumentParser argumentParser = new ArgumentParser(this.configuration.getExtraCommandLineSwitches());
            commandVector.addAll(argumentParser.getTokenList());
        }
        String[] commandArray = new String[commandVector.size()];
        commandArray = commandVector.toArray(commandArray);
        return commandArray;
    }
}

