/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.remote.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.util.DebugUtil;
import org.eclipse.ptp.proxy.runtime.client.AbstractProxyRuntimeClient;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.proxy.util.DebugOptions;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;

public class AbstractRemoteProxyRuntimeClient
extends AbstractProxyRuntimeClient {
    private IRemoteConnection connection = null;
    private AbstractRemoteResourceManagerConfiguration config;

    public AbstractRemoteProxyRuntimeClient(AbstractRemoteResourceManagerConfiguration config, int baseModelId) {
        super(config.getName(), baseModelId);
        this.config = config;
        this.initDebugOptions();
    }

    public AbstractRemoteProxyRuntimeClient(AbstractRemoteResourceManagerConfiguration config, int baseModelId, IProxyRuntimeCommandFactory cmdFactory, IProxyRuntimeEventFactory eventFactory) {
        super(config.getName(), baseModelId, cmdFactory, eventFactory);
        this.config = config;
        this.initDebugOptions();
    }

    public void shutdown(IProgressMonitor monitor) throws IOException {
        this.shutdown();
        try {
            this.sessionFinish();
        }
        catch (IOException e) {
            PTPCorePlugin.log((Throwable)e);
        }
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close(monitor);
        }
    }

    public void startup(IProgressMonitor monitor) throws IOException {
        block24: {
            if (DebugOptions.CLIENT_TRACING) {
                System.out.println(String.valueOf(this.toString()) + " - firing up proxy, waiting for connection.  Please wait!  This can take a minute . . .");
                System.out.println("PROXY_SERVER path = '" + this.config.getName() + "'");
            }
            try {
                IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.config.getRemoteServicesId());
                if (remoteServices == null) {
                    throw new IOException("Could not find remote services ID " + this.config.getRemoteServicesId());
                }
                if (this.config.testOption(4)) {
                    this.sessionCreate();
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(this.config.getProxyServerPath());
                    args.add("--proxy=tcp");
                    if (this.config.testOption(2)) {
                        args.add("--host=localhost");
                    } else {
                        args.add("--host=" + this.config.getLocalAddress());
                    }
                    args.add("--port=" + this.getSessionPort());
                    if (DebugOptions.SERVER_DEBUG_LEVEL > 0) {
                        args.add("--debug=" + DebugOptions.SERVER_DEBUG_LEVEL);
                    }
                    args.addAll(this.config.getInvocationOptions());
                    if (DebugOptions.CLIENT_TRACING) {
                        System.out.println("Launch command: " + ((Object)args).toString());
                    }
                    String msg = "Waiting for manual launch of proxy: " + ((Object)args).toString();
                    System.out.println(msg);
                    Status info = new Status(1, PTPCorePlugin.getUniqueIdentifier(), 1, msg, null);
                    PTPCorePlugin.log((IStatus)info);
                    break block24;
                }
                IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
                this.connection = connMgr.getConnection(this.config.getConnectionName());
                if (this.connection == null) {
                    throw new IOException("No such connection: " + this.config.getConnectionName());
                }
                if (!this.connection.isOpen()) {
                    this.connection.open(monitor);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                IRemoteFileManager fileManager = remoteServices.getFileManager(this.connection);
                IFileStore res = fileManager.getResource((IPath)new Path(this.config.getProxyServerPath()), monitor);
                if (!res.fetchInfo().exists()) {
                    throw new IOException("Could not find proxy executable \"" + this.config.getProxyServerPath() + "\"");
                }
                this.sessionCreate();
                ArrayList<String> args = new ArrayList<String>();
                args.add(this.config.getProxyServerPath());
                args.add("--proxy=tcp");
                if (this.config.testOption(2)) {
                    int remotePort;
                    try {
                        remotePort = this.connection.forwardRemotePort("localhost", this.getSessionPort(), monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new IOException(e.getMessage());
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    args.add("--host=localhost");
                    args.add("--port=" + remotePort);
                } else {
                    args.add("--host=" + this.config.getLocalAddress());
                    args.add("--port=" + this.getSessionPort());
                }
                if (DebugOptions.SERVER_DEBUG_LEVEL > 0) {
                    args.add("--debug=" + DebugOptions.SERVER_DEBUG_LEVEL);
                }
                args.addAll(this.config.getInvocationOptions());
                if (DebugOptions.CLIENT_TRACING) {
                    System.out.println("Launch command: " + args.toString());
                }
                IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(this.connection, args);
                IRemoteProcess process = processBuilder.start();
                final BufferedReader err_reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                final BufferedReader out_reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = out_reader.readLine()) != null) {
                                System.out.println(String.valueOf(AbstractRemoteProxyRuntimeClient.this.config.getName()) + ": " + output);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, "Program output Thread").start();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            while ((line = err_reader.readLine()) != null) {
                                System.err.println(String.valueOf(AbstractRemoteProxyRuntimeClient.this.config.getName()) + ": " + line);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, "Error output Thread").start();
                if (DebugOptions.CLIENT_TRACING) {
                    System.out.println(String.valueOf(this.toString()) + ": Waiting on accept.");
                }
            }
            catch (IOException e) {
                try {
                    this.sessionFinish();
                }
                catch (IOException e1) {
                    PTPCorePlugin.log((Throwable)e1);
                }
                throw new IOException("Failed to start proxy: " + e.getMessage());
            }
            catch (RemoteConnectionException e) {
                throw new IOException("Failed to start proxy: " + e.getMessage());
            }
        }
        this.startup();
    }

    private void initDebugOptions() {
        DebugOptions.PROTOCOL_TRACING = DebugUtil.PROTOCOL_TRACING;
        DebugOptions.CLIENT_TRACING = DebugUtil.PROXY_CLIENT_TRACING;
        DebugOptions.SERVER_DEBUG_LEVEL = DebugUtil.PROXY_SERVER_DEBUG_LEVEL;
    }
}

