/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.core;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.pdt.xml.core.ConfigGroupParserException;
import org.eclipse.ptp.cell.pdt.xml.core.Messages;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.Event;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventSubgroup;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.eclipse.ptp.cell.preferences.PreferencesPlugin;
import org.eclipse.ptp.cell.preferences.ui.PreferenceConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PdtEventForestFactory {
    IPath eventGroupsDir;

    public PdtEventForestFactory(IPath eventGroupsDir) {
        this.eventGroupsDir = eventGroupsDir;
    }

    public EventGroupForest createEmptyEventGroupForest() {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_EVENT_FOREST_GENERATOR);
        EventGroupForest newForest = new EventGroupForest();
        newForest.setVisibleGroups(new HashSet<EventGroup>());
        newForest.setInvisibleGroups(new HashSet<EventGroup>());
        return newForest;
    }

    public EventGroupForest createEventGroupForest() throws ConfigGroupParserException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_EVENT_FOREST_GENERATOR);
        Debug.POLICY.trace(Debug.DEBUG_EVENT_FOREST_GENERATOR, "Event group dir {0}", new Object[]{this.eventGroupsDir});
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        File dir = new File(this.eventGroupsDir.toOSString());
        if (!dir.isDirectory()) {
            ConfigGroupParserException parserException = new ConfigGroupParserException(NLS.bind((String)Messages.PdtEventForestFactory_createEventGroupForest_PathNotADir, (Object)this.eventGroupsDir.toOSString()));
            Debug.POLICY.error(Debug.DEBUG_EVENT_FOREST_GENERATOR, (Throwable)parserException);
            throw parserException;
        }
        IPath sdkroot = this.getSdkSysroot();
        int numofseg = this.eventGroupsDir.matchingFirstSegments(sdkroot);
        IPath evtGrpDirSysrootRel = this.eventGroupsDir.removeFirstSegments(numofseg);
        evtGrpDirSysrootRel = evtGrpDirSysrootRel.makeAbsolute();
        HashSet<EventGroup> visibleGroupSet = new HashSet<EventGroup>();
        HashSet<EventGroup> invisibleGroupSet = new HashSet<EventGroup>();
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory() && !files[i].getName().matches("^pdt_.*_event_header\\.xml$")) {
                ConfigGroupParserException confParseException;
                try {
                    DocumentBuilder parser = factory.newDocumentBuilder();
                    Document xmlFile = parser.parse(files[i]);
                    Node groupNode = xmlFile.getFirstChild();
                    if (!(groupNode instanceof Element) || !groupNode.getNodeName().equals("pdtGroup")) {
                        Debug.POLICY.trace(Debug.DEBUG_EVENT_FOREST_GENERATOR, "File {0} doesn't specify a valid group - ignoring it", new Object[]{files[0]});
                    } else {
                        Element groupElem = (Element)groupNode;
                        EventGroup eventGroup = new EventGroup();
                        eventGroup.setName(groupElem.getAttribute("name"));
                        eventGroup.setId(groupElem.getAttribute("id"));
                        eventGroup.setYStart(new Float(0.0));
                        eventGroup.setYEnd(new Float(0.0));
                        eventGroup.setColor(0);
                        eventGroup.setActive(false);
                        eventGroup.setAssociatedPath(evtGrpDirSysrootRel.append(files[i].getName()));
                        if (eventGroup.getName().equals(EventGroup.GENERAL_GROUP)) {
                            eventGroup.setSubgroups(new HashSet<EventSubgroup>());
                            invisibleGroupSet.add(eventGroup);
                        } else {
                            visibleGroupSet.add(eventGroup);
                            NodeList subgroups = groupElem.getChildNodes();
                            int j = 0;
                            while (j < subgroups.getLength()) {
                                if (subgroups.item(j) instanceof Element) {
                                    if (!subgroups.item(j).getNodeName().equals("subGroup")) {
                                        ConfigGroupParserException cfgGrpParserException = new ConfigGroupParserException(String.valueOf(Messages.PdtEventForestFactory_createEventGroupForest_InvalidElementType) + subgroups.item(j).getNodeName());
                                        Debug.POLICY.error(Debug.DEBUG_EVENT_FOREST_GENERATOR, (Throwable)cfgGrpParserException);
                                        throw cfgGrpParserException;
                                    }
                                    Element subgroupElem = (Element)subgroups.item(j);
                                    EventSubgroup eventSubgroup = new EventSubgroup();
                                    eventGroup.addSubgroup(eventSubgroup);
                                    eventSubgroup.setName(subgroupElem.getAttribute("name"));
                                    eventSubgroup.setId(subgroupElem.getAttribute("id"));
                                    eventSubgroup.setParent(eventGroup);
                                    eventSubgroup.setActive(false);
                                    NodeList events = subgroupElem.getChildNodes();
                                    int k = 0;
                                    while (k < events.getLength()) {
                                        if (events.item(k) instanceof Element) {
                                            if (!events.item(k).getNodeName().equals("recordType")) {
                                                ConfigGroupParserException confGroupParseException = new ConfigGroupParserException(String.valueOf(Messages.PdtEventForestFactory_createEventGroupForest_InvalidElementType) + subgroups.item(j).getNodeName());
                                                Debug.POLICY.error(Debug.DEBUG_EVENT_FOREST_GENERATOR, (Throwable)confGroupParseException);
                                                throw confGroupParseException;
                                            }
                                            Element eventElem = (Element)events.item(k);
                                            Event event = new Event();
                                            eventSubgroup.addEvent(event);
                                            event.setName(eventElem.getAttribute("name"));
                                            event.setId(eventElem.getAttribute("id"));
                                            event.setDescription(eventElem.getAttribute("description"));
                                            event.setType(eventElem.getAttribute("type"));
                                            event.setParent(eventSubgroup);
                                            event.setActive(false);
                                            NodeList include = eventElem.getElementsByTagName("include");
                                            assert (include.getLength() == 1) : "Single include tag is necessary and allowed";
                                            Element includeElem = (Element)include.item(0);
                                            event.setInclude(includeElem.getAttribute("href"));
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                }
                catch (ParserConfigurationException e) {
                    confParseException = new ConfigGroupParserException(e);
                    Debug.POLICY.error(Debug.DEBUG_EVENT_FOREST_GENERATOR, (Throwable)confParseException);
                    throw confParseException;
                }
                catch (SAXException e) {
                    confParseException = new ConfigGroupParserException(e);
                    Debug.POLICY.error(Debug.DEBUG_EVENT_FOREST_GENERATOR, (Throwable)confParseException);
                    throw confParseException;
                }
                catch (IOException e) {
                    confParseException = new ConfigGroupParserException(e);
                    Debug.POLICY.error(Debug.DEBUG_EVENT_FOREST_GENERATOR, (Throwable)confParseException);
                    throw confParseException;
                }
            }
            ++i;
        }
        Debug.POLICY.exit(Debug.DEBUG_EVENT_FOREST_GENERATOR);
        EventGroupForest groups = new EventGroupForest();
        groups.setVisibleGroups(visibleGroupSet);
        groups.setInvisibleGroups(invisibleGroupSet);
        return groups;
    }

    private IPath getSdkSysroot() {
        IPreferenceStore store = PreferencesPlugin.getDefault().getPreferenceStore();
        Path sdkSysroot = new Path(store.getString(PreferenceConstants.SDK_SYSROOT));
        return sdkSysroot;
    }
}

