/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard.ui;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.eclipse.ptp.cell.pdt.xml.wizard.AbstractPdtXmlWizard;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PdtWizardAddRemoveEventsPage
extends WizardPage {
    EventGroupForest selectedEventGroupForest;
    EventGroupForest availableEventGroupForest;
    protected ListViewer availableEventGroups;
    protected ListViewer selectedEventGroups;
    protected Button select;
    protected Button deselect;
    protected Button selectAll;
    protected Button deselectAll;

    public PdtWizardAddRemoveEventsPage(EventGroupForest availableEventGroupForest, EventGroupForest selectedEventGroupForest) {
        super(PdtWizardAddRemoveEventsPage.class.getName());
        this.setTitle(Messages.PdtWizardAddRemoveEventsPage_WizardPage_Title);
        this.setDescription(Messages.PdtWizardAddRemoveEventsPage_WizardPage_Description);
        this.selectedEventGroupForest = selectedEventGroupForest;
        this.availableEventGroupForest = availableEventGroupForest;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 3;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        GridLayoutFactory compLayoutFactory = GridLayoutFactory.swtDefaults();
        compLayoutFactory.numColumns(1);
        GridDataFactory gdFactoryLists = GridDataFactory.swtDefaults();
        gdFactoryLists.grab(true, true);
        gdFactoryLists.align(4, 4);
        Group availEvtGrpComposite = new Group(composite, 2048);
        availEvtGrpComposite.setText(Messages.PdtWizardAddRemoveEventsPage_Group_AvailableEventGroups);
        availEvtGrpComposite.setLayoutData((Object)gdFactoryLists.create());
        availEvtGrpComposite.setLayout((Layout)compLayoutFactory.create());
        GridDataFactory gdFactoryButtons = gdFactoryLists.copy();
        gdFactoryButtons.grab(false, false);
        gdFactoryButtons.align(0x1000000, 0x1000000);
        this.availableEventGroups = new ListViewer((Composite)availEvtGrpComposite);
        this.availableEventGroups.getControl().setLayoutData((Object)gdFactoryLists.create());
        this.availableEventGroups.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.availableEventGroups.setContentProvider((IContentProvider)new PdtEventGroupListContentProvider());
        this.availableEventGroups.setInput((Object)this.availableEventGroupForest);
        Composite buttonHolder = new Composite(composite, 0);
        buttonHolder.setLayoutData((Object)gdFactoryButtons.create());
        FillLayout btnHldLay = new FillLayout(512);
        buttonHolder.setLayout((Layout)btnHldLay);
        ButtonSelectionHandler btnHandle = new ButtonSelectionHandler();
        this.select = new Button(buttonHolder, 8);
        this.select.setText(Messages.PdtWizardAddRemoveEventsPage_Button_Add);
        this.select.addSelectionListener((SelectionListener)btnHandle);
        this.deselect = new Button(buttonHolder, 8);
        this.deselect.setText(Messages.PdtWizardAddRemoveEventsPage_Button_Remove);
        this.deselect.addSelectionListener((SelectionListener)btnHandle);
        this.selectAll = new Button(buttonHolder, 8);
        this.selectAll.setText(Messages.PdtWizardAddRemoveEventsPage_Button_AddAll);
        this.selectAll.addSelectionListener((SelectionListener)btnHandle);
        this.deselectAll = new Button(buttonHolder, 8);
        this.deselectAll.setText(Messages.PdtWizardAddRemoveEventsPage_Button_RemoveAll);
        this.deselectAll.addSelectionListener((SelectionListener)btnHandle);
        Group selEvtGrpComposite = new Group(composite, 2048);
        selEvtGrpComposite.setText(Messages.PdtWizardAddRemoveEventsPage_Group_SelectedEventGroups);
        selEvtGrpComposite.setLayoutData((Object)gdFactoryLists.create());
        selEvtGrpComposite.setLayout((Layout)compLayoutFactory.create());
        this.selectedEventGroups = new ListViewer((Composite)selEvtGrpComposite);
        this.selectedEventGroups.getControl().setLayoutData((Object)gdFactoryLists.create());
        this.selectedEventGroups.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.selectedEventGroups.setContentProvider((IContentProvider)new PdtEventGroupListContentProvider());
        this.selectedEventGroups.setInput((Object)this.selectedEventGroupForest);
        this.setControl((Control)composite);
    }

    protected void selectEventGroups(List eventGroupList) {
        if (eventGroupList.size() > 0) {
            Set<EventGroup> availEvtGrpSet = this.availableEventGroupForest.getVisibleGroups();
            Set<EventGroup> selEvtGrpSet = this.selectedEventGroupForest.getVisibleGroups();
            availEvtGrpSet.removeAll(eventGroupList);
            selEvtGrpSet.addAll(eventGroupList);
            Object[] evtGrpArray = eventGroupList.toArray();
            this.availableEventGroups.remove(evtGrpArray);
            this.selectedEventGroups.add(evtGrpArray);
        }
    }

    protected void removeEventGroups(List eventGroupList) {
        if (eventGroupList.size() > 0) {
            Set<EventGroup> availEvtGrpSet = this.availableEventGroupForest.getVisibleGroups();
            Set<EventGroup> selEvtGrpSet = this.selectedEventGroupForest.getVisibleGroups();
            selEvtGrpSet.removeAll(eventGroupList);
            availEvtGrpSet.addAll(eventGroupList);
            Object[] evtGrpArray = eventGroupList.toArray();
            this.selectedEventGroups.remove(evtGrpArray);
            this.availableEventGroups.add(evtGrpArray);
        }
    }

    protected void selectOrRemove(Button btn, ISelection availableSel, ISelection selectedSel) {
        if (btn.equals(this.select)) {
            List availSelList = ((StructuredSelection)availableSel).toList();
            this.selectEventGroups(availSelList);
        } else if (btn.equals(this.selectAll)) {
            LinkedList<EventGroup> availAllList = new LinkedList<EventGroup>(this.availableEventGroupForest.getVisibleGroups());
            this.selectEventGroups(availAllList);
        } else if (btn.equals(this.deselect)) {
            List selSelList = ((StructuredSelection)selectedSel).toList();
            this.removeEventGroups(selSelList);
        } else if (btn.equals(this.deselectAll)) {
            LinkedList<EventGroup> selAllList = new LinkedList<EventGroup>(this.selectedEventGroupForest.getVisibleGroups());
            this.removeEventGroups(selAllList);
        }
        ((AbstractPdtXmlWizard)this.getWizard()).refresh();
    }

    protected class ButtonSelectionHandler
    extends SelectionAdapter {
        protected ButtonSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                PdtWizardAddRemoveEventsPage.this.selectOrRemove((Button)e.widget, PdtWizardAddRemoveEventsPage.this.availableEventGroups.getSelection(), PdtWizardAddRemoveEventsPage.this.selectedEventGroups.getSelection());
            }
            catch (Exception exception) {
                Debug.POLICY.logError((Throwable)exception);
            }
        }
    }

    public class PdtEventGroupListContentProvider
    implements IContentProvider,
    IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList<EventGroup> eventGroupList = new LinkedList<EventGroup>();
            for (EventGroup eventGroup : ((EventGroupForest)inputElement).getVisibleGroups()) {
                if (eventGroup.getName().equals(EventGroup.GENERAL_GROUP)) continue;
                eventGroupList.add(eventGroup);
            }
            return eventGroupList.toArray();
        }

        public void addElement(Object element) {
        }
    }
}

