/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorObjectStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;
import org.eclipse.cdt.internal.core.parser.scanner.ASTBuiltinName;
import org.eclipse.cdt.internal.core.parser.scanner.ASTFileLocationForBuiltins;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorDefinition;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorName;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorNode;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ASTMacroDefinition
extends ASTPreprocessorNode
implements IASTPreprocessorObjectStyleMacroDefinition {
    private final ASTPreprocessorName fName;
    private final int fExpansionNumber;
    private final int fExpansionOffset;

    public ASTMacroDefinition(IASTTranslationUnit parent, IMacroBinding macro, int startNumber, int nameNumber, int nameEndNumber, int expansionNumber, int endNumber) {
        super(parent, IASTTranslationUnit.PREPROCESSOR_STATEMENT, startNumber, endNumber);
        this.fExpansionNumber = expansionNumber;
        this.fExpansionOffset = -1;
        this.fName = new ASTPreprocessorDefinition(this, IASTPreprocessorMacroDefinition.MACRO_NAME, nameNumber, nameEndNumber, macro.getNameCharArray(), macro);
    }

    public ASTMacroDefinition(IASTTranslationUnit parent, IMacroBinding macro, IASTFileLocation floc, int expansionOffset) {
        super(parent, IASTTranslationUnit.PREPROCESSOR_STATEMENT, -1, -1);
        this.fName = new ASTBuiltinName(this, IASTPreprocessorMacroDefinition.MACRO_NAME, floc, macro.getNameCharArray(), macro);
        this.fExpansionNumber = -1;
        this.fExpansionOffset = expansionOffset;
    }

    @Override
    public String getContainingFilename() {
        if (this.fName instanceof ASTBuiltinName) {
            return this.fName.getContainingFilename();
        }
        return super.getContainingFilename();
    }

    protected IMacroBinding getMacro() {
        return (IMacroBinding)this.fName.getBinding();
    }

    @Override
    public String getExpansion() {
        return new String(this.getMacro().getExpansion());
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public int getRoleForName(IASTName n) {
        return this.fName == n ? 2 : 3;
    }

    @Override
    void findNode(ASTNodeSpecification<?> nodeSpec) {
        super.findNode(nodeSpec);
        nodeSpec.visit(this.fName);
    }

    @Override
    public void setExpansion(String exp) {
        assert (false);
    }

    @Override
    public void setName(IASTName name) {
        assert (false);
    }

    @Override
    public IASTFileLocation getExpansionLocation() {
        String fileName;
        ILocationResolver lr;
        IASTTranslationUnit ast;
        if (this.fExpansionNumber >= 0 && (ast = this.getTranslationUnit()) != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null) {
            return lr.getMappedFileLocation(this.fExpansionNumber, this.getOffset() + this.getLength() - this.fExpansionNumber);
        }
        if (this.fExpansionOffset >= 0 && (fileName = this.fName.getContainingFilename()) != null) {
            char[] expansionImage = this.getMacro().getExpansionImage();
            return new ASTFileLocationForBuiltins(fileName, this.fExpansionOffset, expansionImage.length);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getName().toString()) + '=' + this.getExpansion();
    }
}

