/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.io.PrintStream;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;

public class ASTPrinter {
    private static boolean PRINT_PARENT_PROPERTIES = false;
    private static boolean RESOLVE_BINDINGS = false;

    public static boolean print(IASTNode root, PrintStream out) {
        int n;
        int n2;
        IASTNode[] iASTNodeArray;
        IASTPreprocessorStatement[] preStats;
        if (root == null) {
            out.println("null");
            return false;
        }
        if (root instanceof IASTTranslationUnit && (preStats = ((IASTTranslationUnit)root).getAllPreprocessorStatements()) != null) {
            iASTNodeArray = preStats;
            n2 = preStats.length;
            n = 0;
            while (n < n2) {
                IASTPreprocessorStatement stat = iASTNodeArray[n];
                ASTPrinter.print(out, 0, stat);
                ++n;
            }
        }
        root.accept(new PrintVisitor(out));
        if (root instanceof IASTTranslationUnit) {
            IASTComment[] comments;
            IASTProblem[] problems = ((IASTTranslationUnit)root).getPreprocessorProblems();
            if (problems != null) {
                iASTNodeArray = problems;
                n2 = problems.length;
                n = 0;
                while (n < n2) {
                    IASTNode problem = iASTNodeArray[n];
                    ASTPrinter.print(out, 0, problem);
                    ++n;
                }
            }
            if ((comments = ((IASTTranslationUnit)root).getComments()) != null) {
                IASTComment[] iASTCommentArray = comments;
                int n3 = comments.length;
                n2 = 0;
                while (n2 < n3) {
                    IASTComment comment = iASTCommentArray[n2];
                    ASTPrinter.print(out, 0, comment);
                    ++n2;
                }
            }
        }
        return false;
    }

    public static boolean print(IASTNode root) {
        return ASTPrinter.print(root, System.out);
    }

    public static boolean printProblems(IASTNode root, PrintStream out) {
        IASTProblem[] problems;
        if (root == null) {
            out.println("null");
            return false;
        }
        root.accept(new ProblemVisitor(out));
        if (root instanceof IASTTranslationUnit && (problems = ((IASTTranslationUnit)root).getPreprocessorProblems()) != null) {
            IASTProblem[] iASTProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IASTProblem problem = iASTProblemArray[n2];
                ASTPrinter.print(out, 0, problem);
                ++n2;
            }
        }
        return false;
    }

    public static boolean printProblems(IASTNode root) {
        return ASTPrinter.printProblems(root, System.out);
    }

    private static void print(PrintStream out, int indentLevel, Object n) {
        Object pointer;
        int i = 0;
        while (i < indentLevel) {
            out.print("  ");
            ++i;
        }
        if (n == null) {
            out.println("NULL");
            return;
        }
        String classname = n.getClass().getName();
        out.print(classname);
        if (n instanceof ASTNode) {
            ASTNode node = (ASTNode)n;
            out.print(" (" + node.getOffset() + "," + node.getLength() + ") ");
            if (node.getParent() == null && !(node instanceof IASTTranslationUnit)) {
                out.print("PARENT IS NULL ");
            }
            if (PRINT_PARENT_PROPERTIES) {
                out.print(node.getPropertyInParent());
            }
        }
        if (n instanceof ICArrayType) {
            ICArrayType at = (ICArrayType)n;
            try {
                if (at.isRestrict()) {
                    out.print(" restrict");
                }
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
        if (n instanceof IASTName) {
            out.print(" " + ((IASTName)n).toString());
        } else if (n instanceof ICASTPointer) {
            pointer = (ICASTPointer)n;
            if (pointer.isConst()) {
                out.print(" const");
            }
            if (pointer.isVolatile()) {
                out.print(" volatile");
            }
            if (pointer.isRestrict()) {
                out.print(" restrict");
            }
        } else if (n instanceof ICPointerType) {
            pointer = (ICPointerType)n;
            if (pointer.isConst()) {
                out.print(" const");
            }
            if (pointer.isVolatile()) {
                out.print(" volatile");
            }
            if (pointer.isRestrict()) {
                out.print(" restrict");
            }
            out.println();
            try {
                ASTPrinter.print(out, indentLevel, ((ITypeContainer)n).getType());
            }
            catch (Exception exception) {}
        } else if (n instanceof ICASTArrayModifier) {
            if (((ICASTArrayModifier)n).isRestrict()) {
                out.print(" restrict");
            }
        } else if (n instanceof IASTComment) {
            out.print("'" + new String(((IASTComment)n).getComment()) + "'");
        } else if (n instanceof ITypeContainer) {
            out.println();
            try {
                ASTPrinter.print(out, indentLevel, ((ITypeContainer)n).getType());
            }
            catch (Exception exception) {}
        } else if (n instanceof IVariable) {
            IVariable var = (IVariable)n;
            try {
                IType t = var.getType();
                out.println();
                ASTPrinter.print(out, indentLevel, t);
            }
            catch (DOMException dOMException) {}
        } else if (n instanceof IProblemBinding) {
            IProblemBinding problem = (IProblemBinding)n;
            out.print(problem.getMessage());
        }
        out.println();
    }

    private static class PrintVisitor
    extends CPPASTVisitor {
        private PrintStream out;
        private int indentLevel = 0;

        PrintVisitor(PrintStream out) {
            this.out = out;
            this.shouldVisitTemplateParameters = true;
            this.shouldVisitNamespaces = true;
            this.shouldVisitBaseSpecifiers = true;
            this.shouldVisitDesignators = true;
            this.shouldVisitProblems = true;
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitEnumerators = true;
            this.shouldVisitTypeIds = true;
            this.shouldVisitStatements = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitParameterDeclarations = true;
            this.shouldVisitInitializers = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitNames = true;
        }

        private void print(IASTNode node) {
            ASTPrinter.print(this.out, this.indentLevel, node);
        }

        private void print(IBinding binding) {
            ASTPrinter.print(this.out, this.indentLevel, binding);
        }

        public int visit(IASTDeclaration declaration) {
            this.print(declaration);
            ++this.indentLevel;
            return super.visit(declaration);
        }

        public int visit(IASTDeclarator declarator) {
            IASTPointerOperator[] pointers;
            this.print(declarator);
            ++this.indentLevel;
            IASTPointerOperator[] iASTPointerOperatorArray = pointers = declarator.getPointerOperators();
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
                this.print(pointer);
                ++n2;
            }
            if (declarator instanceof IASTArrayDeclarator) {
                IASTArrayModifier[] modifiers;
                IASTArrayDeclarator decl = (IASTArrayDeclarator)declarator;
                IASTArrayModifier[] iASTArrayModifierArray = modifiers = decl.getArrayModifiers();
                int n3 = modifiers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTArrayModifier modifier = iASTArrayModifierArray[n4];
                    this.print(modifier);
                    ++n4;
                }
            }
            return super.visit(declarator);
        }

        public int visit(IASTDeclSpecifier declSpec) {
            this.print(declSpec);
            ++this.indentLevel;
            return super.visit(declSpec);
        }

        public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            this.print(enumerator);
            ++this.indentLevel;
            return super.visit(enumerator);
        }

        public int visit(IASTExpression expression) {
            this.print(expression);
            ++this.indentLevel;
            return super.visit(expression);
        }

        public int visit(IASTInitializer initializer) {
            this.print(initializer);
            ++this.indentLevel;
            return super.visit(initializer);
        }

        public int visit(IASTName name) {
            this.print(name);
            if (RESOLVE_BINDINGS) {
                try {
                    IBinding binding = name.resolveBinding();
                    this.print(binding);
                }
                catch (Exception exception) {
                    System.out.println("Exception while resolving binding: " + name);
                }
            }
            ++this.indentLevel;
            return super.visit(name);
        }

        public int visit(IASTParameterDeclaration parameterDeclaration) {
            this.print(parameterDeclaration);
            ++this.indentLevel;
            return super.visit(parameterDeclaration);
        }

        public int visit(IASTProblem problem) {
            this.print(problem);
            ++this.indentLevel;
            return super.visit(problem);
        }

        public int visit(IASTStatement statement) {
            this.print(statement);
            ++this.indentLevel;
            return super.visit(statement);
        }

        public int visit(IASTTranslationUnit tu) {
            this.print(tu);
            ++this.indentLevel;
            return super.visit(tu);
        }

        public int visit(IASTTypeId typeId) {
            this.print(typeId);
            ++this.indentLevel;
            return super.visit(typeId);
        }

        public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
            this.print(baseSpecifier);
            ++this.indentLevel;
            return super.visit(baseSpecifier);
        }

        public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
            this.print(namespaceDefinition);
            ++this.indentLevel;
            return super.visit(namespaceDefinition);
        }

        public int visit(ICPPASTTemplateParameter templateParameter) {
            this.print(templateParameter);
            ++this.indentLevel;
            return super.visit(templateParameter);
        }

        public int leave(IASTDeclaration declaration) {
            --this.indentLevel;
            return super.leave(declaration);
        }

        public int leave(IASTDeclarator declarator) {
            --this.indentLevel;
            return super.leave(declarator);
        }

        public int leave(IASTDeclSpecifier declSpec) {
            --this.indentLevel;
            return super.leave(declSpec);
        }

        public int leave(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            --this.indentLevel;
            return super.leave(enumerator);
        }

        public int leave(IASTExpression expression) {
            --this.indentLevel;
            return super.leave(expression);
        }

        public int leave(IASTInitializer initializer) {
            --this.indentLevel;
            return super.leave(initializer);
        }

        public int leave(IASTName name) {
            --this.indentLevel;
            return super.leave(name);
        }

        public int leave(IASTParameterDeclaration parameterDeclaration) {
            --this.indentLevel;
            return super.leave(parameterDeclaration);
        }

        public int leave(IASTProblem problem) {
            --this.indentLevel;
            return super.leave(problem);
        }

        public int leave(IASTStatement statement) {
            --this.indentLevel;
            return super.leave(statement);
        }

        public int leave(IASTTranslationUnit tu) {
            --this.indentLevel;
            return super.leave(tu);
        }

        public int leave(IASTTypeId typeId) {
            --this.indentLevel;
            return super.leave(typeId);
        }

        public int leave(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
            --this.indentLevel;
            return super.leave(baseSpecifier);
        }

        public int leave(ICPPASTNamespaceDefinition namespaceDefinition) {
            --this.indentLevel;
            return super.leave(namespaceDefinition);
        }

        public int leave(ICPPASTTemplateParameter templateParameter) {
            --this.indentLevel;
            return super.leave(templateParameter);
        }
    }

    private static class ProblemVisitor
    extends ASTVisitor {
        private PrintStream out;

        ProblemVisitor(PrintStream out) {
            this.out = out;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitProblems = true;
        }

        public int visit(IASTProblem problem) {
            ASTPrinter.print(this.out, 1, problem);
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTProblemDeclaration) {
                ASTPrinter.print(this.out, 0, declaration);
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTProblemExpression) {
                ASTPrinter.print(this.out, 0, expression);
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTProblemStatement) {
                ASTPrinter.print(this.out, 0, statement);
            }
            return 3;
        }
    }
}

