/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplateInstantiator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPDeferredClassInstance
extends CPPUnknownClass
implements ICPPDeferredClassInstance {
    private final IType[] fArguments;
    private final ObjectMap fArgmap;
    private final ICPPClassTemplate fClassTemplate;

    public CPPDeferredClassInstance(ICPPClassTemplate orig, ObjectMap argMap, IType[] arguments) {
        super(orig);
        this.fArgmap = argMap;
        this.fArguments = arguments;
        this.fClassTemplate = orig;
    }

    private ICPPClassTemplate getClassTemplate() {
        return (ICPPClassTemplate)this.getSpecializedBinding();
    }

    public CPPDeferredClassInstance clone() {
        CPPDeferredClassInstance cloned = (CPPDeferredClassInstance)super.clone();
        return cloned;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        ICPPClassTemplate classTemplate = this.getClassTemplate();
        if (type instanceof ICPPDeferredClassInstance) {
            IType[] rhsArgs;
            ICPPDeferredClassInstance rhs = (ICPPDeferredClassInstance)type;
            if (!classTemplate.isSameType((IType)((Object)rhs.getSpecializedBinding()))) {
                return false;
            }
            IType[] lhsArgs = this.getArguments();
            if (lhsArgs != (rhsArgs = rhs.getArguments())) {
                if (lhsArgs == null || rhsArgs == null) {
                    return false;
                }
                if (lhsArgs.length != rhsArgs.length) {
                    return false;
                }
                int i = 0;
                while (i < lhsArgs.length) {
                    if (!CPPTemplates.isSameTemplateArgument(lhsArgs[i], rhsArgs[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public int getKey() throws DOMException {
        return this.getClassTemplate().getKey();
    }

    public IType[] getArguments() {
        return this.fArguments;
    }

    public ICPPTemplateDefinition getTemplateDefinition() {
        return this.fClassTemplate;
    }

    public ObjectMap getArgumentMap() {
        return this.fArgmap;
    }

    public IBinding resolvePartially(ICPPUnknownBinding parentBinding, ObjectMap argMap, ICPPScope instantiationScope) {
        IType[] newArgs;
        IType[] arguments = this.getArguments();
        boolean changed = arguments != (newArgs = CPPTemplates.instantiateTypes(arguments, argMap, instantiationScope));
        ICPPClassTemplate classTemplate = this.getClassTemplate();
        if (argMap.containsKey(classTemplate)) {
            classTemplate = (ICPPClassTemplate)argMap.get(classTemplate);
            changed = true;
        }
        if (!changed) {
            return this;
        }
        return ((ICPPInternalTemplateInstantiator)((Object)classTemplate)).instantiate(newArgs);
    }

    public IBinding getSpecializedBinding() {
        return this.getTemplateDefinition();
    }

    public IScope getScope() throws DOMException {
        return this.fClassTemplate.getScope();
    }
}

