/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.core.runtime.CoreException;

public class PDOMInclude
implements IIndexFragmentInclude {
    private static final int INCLUDES_FILE_OR_NAME = 0;
    private static final int INCLUDED_BY = 4;
    private static final int INCLUDES_NEXT = 8;
    private static final int INCLUDED_BY_NEXT = 12;
    private static final int INCLUDED_BY_PREV = 16;
    private static final int NODE_OFFSET_OFFSET = 20;
    private static final int NODE_LENGTH_OFFSET = 24;
    private static final int FLAG_OFFSET = 26;
    private static final int RECORD_SIZE = 27;
    private static final int FLAG_SYSTEM_INCLUDE = 1;
    private static final int FLAG_INACTIVE_INCLUDE = 2;
    private static final int FLAG_UNRESOLVED_INCLUDE = 4;
    private final PDOM pdom;
    private final int record;
    private String fName = null;

    public PDOMInclude(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMInclude(PDOM pdom, IASTPreprocessorIncludeStatement include, PDOMFile containerFile, PDOMFile targetFile) throws CoreException {
        this.pdom = pdom;
        this.record = pdom.getDB().malloc(27);
        IASTName name = include.getName();
        IASTFileLocation loc = name.getFileLocation();
        if (loc != null) {
            this.setNameOffsetAndLength(loc.getNodeOffset(), (short)loc.getNodeLength());
        }
        this.setFlag(this.encodeFlags(include, targetFile == null));
        this.setIncludedBy(containerFile);
        this.setIncludes(targetFile, name.toCharArray());
    }

    private byte encodeFlags(IASTPreprocessorIncludeStatement include, boolean unresolved) {
        byte flags = 0;
        if (include.isSystemInclude()) {
            flags = (byte)(flags | 1);
        }
        if (!include.isActive()) {
            flags = (byte)(flags | 2);
        }
        if (unresolved) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        if (this.isResolved()) {
            this.removeThisFromIncludedByChain();
        } else {
            this.getNameForUnresolved().delete();
        }
        this.pdom.getDB().free(this.record);
    }

    private void removeThisFromIncludedByChain() throws CoreException {
        PDOMInclude prevInclude = this.getPrevInIncludedBy();
        PDOMInclude nextInclude = this.getNextInIncludedBy();
        if (prevInclude != null) {
            prevInclude.setNextInIncludedBy(nextInclude);
        } else {
            ((PDOMFile)this.getIncludes()).setFirstIncludedBy(nextInclude);
        }
        if (nextInclude != null) {
            nextInclude.setPrevInIncludedBy(prevInclude);
        }
    }

    private IString getNameForUnresolved() throws CoreException {
        if (this.isResolved()) {
            return null;
        }
        Database db = this.pdom.getDB();
        return db.getString(db.getInt(this.record + 0));
    }

    public IIndexFragmentFile getIncludes() throws CoreException {
        if (!this.isResolved()) {
            return null;
        }
        int rec = this.pdom.getDB().getInt(this.record + 0);
        return rec != 0 ? new PDOMFile(this.pdom, rec) : null;
    }

    private void setIncludes(PDOMFile includes, char[] name) throws CoreException {
        int rec = 0;
        rec = includes == null ? this.pdom.getDB().newString(name).getRecord() : includes.getRecord();
        this.pdom.getDB().putInt(this.record + 0, rec);
    }

    public IIndexFile getIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 4);
        return rec != 0 ? new PDOMFile(this.pdom, rec) : null;
    }

    private void setIncludedBy(PDOMFile includedBy) throws CoreException {
        int rec = includedBy != null ? includedBy.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 4, rec);
    }

    public PDOMInclude getNextInIncludes() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 8);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public void setNextInIncludes(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 8, rec);
    }

    public PDOMInclude getNextInIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public void setNextInIncludedBy(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public PDOMInclude getPrevInIncludedBy() throws CoreException {
        int rec = this.getPrevInIncludedByRecord();
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    int getPrevInIncludedByRecord() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 16);
    }

    public void setPrevInIncludedBy(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 16, rec);
    }

    public IIndexFileLocation getIncludedByLocation() throws CoreException {
        return this.getIncludedBy().getLocation();
    }

    public IIndexFileLocation getIncludesLocation() throws CoreException {
        if (!this.isResolved()) {
            return null;
        }
        return this.getIncludes().getLocation();
    }

    public IIndexFragment getFragment() {
        return this.pdom;
    }

    private void setNameOffsetAndLength(int offset, short length) throws CoreException {
        this.pdom.getDB().putInt(this.record + 20, offset);
        this.pdom.getDB().putShort(this.record + 24, length);
    }

    private void setFlag(byte flag) throws CoreException {
        this.pdom.getDB().putByte(this.record + 26, flag);
    }

    private int getFlag() throws CoreException {
        return this.pdom.getDB().getByte(this.record + 26);
    }

    public boolean isSystemInclude() throws CoreException {
        return (this.getFlag() & 1) != 0;
    }

    public boolean isActive() throws CoreException {
        return (this.getFlag() & 2) == 0;
    }

    public boolean isResolved() throws CoreException {
        return (this.getFlag() & 4) == 0;
    }

    public int getNameOffset() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 20);
    }

    public int getNameLength() throws CoreException {
        return this.pdom.getDB().getShort(this.record + 24) & 0xFFFF;
    }

    public String getName() throws CoreException {
        if (this.fName == null) {
            this.computeName();
        }
        return this.fName;
    }

    private void computeName() throws CoreException {
        this.fName = this.isResolved() ? this.getIncludes().getLocation().getURI().getPath() : this.getNameForUnresolved().getString();
        this.fName = this.fName.substring(this.fName.lastIndexOf(47) + 1);
    }

    public void convertToUnresolved() throws CoreException {
        if (this.isResolved()) {
            this.setIncludes(null, this.getName().toCharArray());
            this.setFlag((byte)(this.getFlag() | 4));
        }
    }
}

