/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.events;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.CellManagerSelectionPage;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ManageEnvironmentAction
implements IViewActionDelegate {
    IViewPart view = null;
    ISelection selection = null;

    public void init(IViewPart v) {
        this.view = v;
    }

    public void run(IAction action) {
        Debug.POLICY.enter(Debug.DEBUG_JOBS);
        Shell shell = this.view.getViewSite().getShell();
        Object obj = ((IStructuredSelection)this.selection).getFirstElement();
        if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
            try {
                ITargetElement element = (ITargetElement)obj;
                ITargetControl control = element.getControl();
                if (control.query() == 2 || control.query() == 3) {
                    this.openWizard(control);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.ManageEnvironmentAction_0, (String)Messages.ManageEnvironmentAction_1);
                }
                return;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        MessageDialog.openInformation((Shell)shell, (String)Messages.ManageEnvironmentAction_2, (String)Messages.ManageEnvironmentAction_3);
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }

    private void openWizard(final ITargetControl control) {
        Wizard wizard = new Wizard(){

            public void addPages() {
                this.addPage((IWizardPage)new CellManagerSelectionPage("CellManagerSelectionPage", control));
            }

            public boolean canFinish() {
                return false;
            }

            public boolean performFinish() {
                return false;
            }
        };
        wizard.setWindowTitle(Messages.ManageEnvironmentAction_4);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.view.getViewSite().getShell(), (IWizard)wizard);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection newSelection) {
        this.selection = newSelection;
    }
}

