/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.wizard;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.ptp.cell.environment.ui.deploy.DeployPlugin;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.CellDeleteResourcesPage;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.CellExportResourcesPage;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.CellImportResourcesPage;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CellManagerSelectionPage
extends WizardSelectionPage
implements SelectionListener,
MouseListener {
    private ITargetControl cellControl;
    private Table table;
    private IWizardNode[] nodes;
    private boolean initialSelection;

    protected CellManagerSelectionPage(String pageName) {
        super(pageName);
    }

    public CellManagerSelectionPage(String pageName, ITargetControl control) {
        super(pageName);
        this.cellControl = control;
        this.nodes = new IWizardNode[3];
        this.nodes[0] = new CopyToEnvWizardNode();
        this.nodes[1] = new CopyFromEnvWizardNode();
        this.nodes[2] = new DeleteFromEnvWizardNode();
        this.initialSelection = true;
        this.setTitle(Messages.CellManagerSelectionPage_6);
        this.setMessage(Messages.CellManagerSelectionPage_7);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (this.initialSelection) {
                this.table.deselectAll();
                this.initialSelection = false;
                return;
            }
            int index = this.table.getSelectionIndex();
            if (index != -1) {
                this.setSelectedNode(this.nodes[index]);
                this.setMessage(this.nodes[index].toString());
            }
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.table = new Table(composite, 65540);
        GridData data = new GridData(768);
        data.widthHint = 300;
        data.heightHint = 250;
        this.table.setLayoutData((Object)data);
        this.table.setFont(composite.getFont());
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        this.table.setEnabled(true);
        this.table.setVisible(true);
        this.table.addSelectionListener((SelectionListener)this);
        this.table.addMouseListener((MouseListener)this);
        TableItem item1 = new TableItem(this.table, 0, 0);
        TableItem item2 = new TableItem(this.table, 0, 1);
        TableItem item3 = new TableItem(this.table, 0, 2);
        item1.setText(Messages.CellManagerSelectionPage_8);
        item1.setImage(DeployPlugin.getImageDescriptor("icons/copy_to.png").createImage());
        item2.setText(Messages.CellManagerSelectionPage_9);
        item2.setImage(DeployPlugin.getImageDescriptor("icons/copy_from.png").createImage());
        item3.setText(Messages.CellManagerSelectionPage_10);
        item3.setImage(DeployPlugin.getImageDescriptor("icons/delete.png").createImage());
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    public void dispose() {
        super.dispose();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            Image temp = items[i].getImage();
            if (temp != null) {
                temp.dispose();
            }
            ++i;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        try {
            IWizardPage page;
            int index;
            Object source = e.getSource();
            if (source instanceof Table && source == this.table && (index = this.table.getSelectionIndex()) != -1 && (page = this.getNextPage()) != null) {
                this.getContainer().showPage(page);
            }
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    class CopyFromEnvWizardNode
    implements IWizardNode {
        Wizard copyFromEnvWizard;

        CopyFromEnvWizardNode() {
        }

        public void dispose() {
            if (this.copyFromEnvWizard != null) {
                this.copyFromEnvWizard.dispose();
            }
        }

        public Point getExtent() {
            return new Point(0, 0);
        }

        public IWizard getWizard() {
            if (this.copyFromEnvWizard == null) {
                this.copyFromEnvWizard = new Wizard(){

                    public void addPages() {
                        this.addPage((IWizardPage)new CellImportResourcesPage("CellImportResourcesPage", CellManagerSelectionPage.this.cellControl));
                    }

                    public boolean performFinish() {
                        CellImportResourcesPage page = (CellImportResourcesPage)this.getStartingPage();
                        return page.finish();
                    }
                };
                this.copyFromEnvWizard.setWindowTitle(Messages.CellManagerSelectionPage_2);
            }
            return this.copyFromEnvWizard;
        }

        public boolean isContentCreated() {
            return this.copyFromEnvWizard != null;
        }

        public String toString() {
            return Messages.CellManagerSelectionPage_3;
        }
    }

    class CopyToEnvWizardNode
    implements IWizardNode {
        Wizard copyToEnvWizard;

        CopyToEnvWizardNode() {
        }

        public void dispose() {
            if (this.copyToEnvWizard != null) {
                this.copyToEnvWizard.dispose();
            }
        }

        public Point getExtent() {
            return new Point(0, 0);
        }

        public IWizard getWizard() {
            if (this.copyToEnvWizard == null) {
                this.copyToEnvWizard = new Wizard(){

                    public void addPages() {
                        this.addPage((IWizardPage)new CellExportResourcesPage("CellExportResourcesPage", CellManagerSelectionPage.this.cellControl));
                    }

                    public boolean performFinish() {
                        CellExportResourcesPage page = (CellExportResourcesPage)this.getStartingPage();
                        return page.finish();
                    }
                };
                this.copyToEnvWizard.setWindowTitle(Messages.CellManagerSelectionPage_0);
            }
            return this.copyToEnvWizard;
        }

        public boolean isContentCreated() {
            return this.copyToEnvWizard != null;
        }

        public String toString() {
            return Messages.CellManagerSelectionPage_1;
        }
    }

    class DeleteFromEnvWizardNode
    implements IWizardNode {
        Wizard deleteFromEnvWizard;

        DeleteFromEnvWizardNode() {
        }

        public void dispose() {
            if (this.deleteFromEnvWizard != null) {
                this.deleteFromEnvWizard.dispose();
            }
        }

        public Point getExtent() {
            return new Point(0, 0);
        }

        public IWizard getWizard() {
            if (this.deleteFromEnvWizard == null) {
                this.deleteFromEnvWizard = new Wizard(){

                    public void addPages() {
                        this.addPage((IWizardPage)new CellDeleteResourcesPage("CellDeleteResourcesPage", CellManagerSelectionPage.this.cellControl));
                    }

                    public boolean performFinish() {
                        CellDeleteResourcesPage page = (CellDeleteResourcesPage)this.getStartingPage();
                        return page.finish();
                    }
                };
                this.deleteFromEnvWizard.setWindowTitle(Messages.CellManagerSelectionPage_4);
            }
            return this.deleteFromEnvWizard;
        }

        public boolean isContentCreated() {
            return this.deleteFromEnvWizard != null;
        }

        public String toString() {
            return Messages.CellManagerSelectionPage_5;
        }
    }
}

