/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventResultRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListArgumentsRequest;

public abstract class AbstractListArgumentsRequest
extends AbstractEventResultRequest
implements IPDIListArgumentsRequest {
    private int low = 0;
    private int high = 0;

    public AbstractListArgumentsRequest(BitList tasks, int low, int high) {
        super(tasks);
        this.low = low;
        this.high = high;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.listArguments(this.tasks, this.low, this.high);
    }

    public String[] getArguments(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        throw new PDIException(qTasks, "No arguments found");
    }

    public String getName() {
        return "List arguments request";
    }
}

