/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.rm.core.ToolsRMPlugin;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2MachineAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2JobMap;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2ListJobsParser;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;

public class MPICH2PeriodicJob
extends AbstractRemoteCommandJob {
    MPICH2RuntimeSystem rts;

    public MPICH2PeriodicJob(MPICH2RuntimeSystem rts) {
        super((AbstractToolRuntimeSystem)rts, NLS.bind((String)Messages.MPICH2MonitorJob_name, (Object)rts.getRmConfiguration().getName()), rts.retrieveEffectiveToolRmConfiguration().getPeriodicMonitorCmd(), Messages.MPICH2MonitorJob_interruptedErrorMessage, Messages.MPICH2MonitorJob_processErrorMessage, Messages.MPICH2MonitorJob_parsingErrorMessage, rts.retrieveEffectiveToolRmConfiguration().getPeriodicMonitorTime());
        this.rts = rts;
    }

    protected void parse(BufferedReader output) throws CoreException {
        IResourceManager rm = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rts.getRmID());
        IPMachine machine = rm.getMachineById(this.rts.getMachineID());
        IPQueue queue = rm.getQueueById(this.rts.getQueueID());
        if (machine == null || queue == null) {
            return;
        }
        try {
            MPICH2ListJobsParser parser = new MPICH2ListJobsParser();
            MPICH2JobMap jobMap = parser.parse(output);
            if (jobMap == null) {
                throw new CoreException((IStatus)new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), parser.getErrorMessage()));
            }
            for (List<MPICH2JobMap.Job> jobs : jobMap.getJobs()) {
                for (MPICH2JobMap.Job job : jobs) {
                    IPProcessControl process;
                    IPJob pJob = queue.getJobById(job.getJobAlias());
                    if (pJob == null || (process = (IPProcessControl)pJob.getProcessByIndex(job.getRank())) != null) continue;
                    String nodeID = this.rts.getNodeIDforName(job.getHost());
                    if (nodeID == null) {
                        throw new CoreException((IStatus)new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.MPICH2RuntimeSystemJob_Exception_HostnamesDoNotMatch, null));
                    }
                    String processName = Integer.toString(job.getRank());
                    String processID = this.rts.createProcess(job.getJobAlias(), processName, job.getRank());
                    process = (IPProcessControl)pJob.getProcessById(processID);
                    IPNode node = machine.getNodeById(nodeID);
                    IPNodeControl nodeControl = (IPNodeControl)node;
                    nodeControl.addProcesses(Arrays.asList(process));
                    process.setState(ProcessAttributes.State.RUNNING);
                }
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 4) {
                AttributeManager attrManager = new AttributeManager();
                attrManager.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
                attrManager.addAttribute((IAttribute)MPICH2MachineAttributes.getStatusMessageAttributeDefinition().create(NLS.bind((String)Messages.MPICH2MonitorJob_Exception_CommandFailed, (Object)e.getMessage())));
                this.rts.changeMachine(machine.getID(), attrManager);
            }
            throw e;
        }
        catch (Exception e) {
            AttributeManager attrManager = new AttributeManager();
            attrManager.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
            attrManager.addAttribute((IAttribute)MPICH2MachineAttributes.getStatusMessageAttributeDefinition().create(NLS.bind((String)Messages.MPICH2MonitorJob_Exception_InternalError, (Object)e.getMessage())));
            this.rts.changeMachine(machine.getID(), attrManager);
        }
    }
}

