/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.examples.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.cell.examples.ui.internal.ExampleMessages;
import org.eclipse.ptp.cell.examples.ui.internal.ProjectWizardDefinition;
import org.eclipse.ptp.cell.examples.ui.internal.wizards.ExampleProjectCreationWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.Bundle;

public class ExampleProjectCreationOperation
implements IRunnableWithProgress {
    private Shell wizardShell;
    private IWizardPage[] wizardPages;
    private ProjectWizardDefinition projectWizardDefinition;
    private IResource fileToOpen;

    public ExampleProjectCreationOperation(Wizard wizard) {
        this.wizardShell = wizard.getShell();
        this.wizardPages = wizard.getPages();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(ExampleMessages.creatingExampleProjects, this.wizardPages.length);
            int i = 0;
            while (i < this.wizardPages.length) {
                this.createProject((ExampleProjectCreationWizardPage)this.wizardPages[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createProject(ExampleProjectCreationWizardPage wizardPage, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.projectWizardDefinition = wizardPage.getProjectWizardDefinition();
        monitor.beginTask(ExampleMessages.configuringProject, 1);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = this.getNewProjectOpened(root, wizardPage.getProjectName(), monitor);
        this.doImport(project.getFullPath(), this.projectWizardDefinition.getSourceZip(), this.projectWizardDefinition.getZipInternalRelativePath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        String fileToOpenPath = this.projectWizardDefinition.getFileToOpen();
        if (fileToOpenPath != null && fileToOpenPath.length() > 0) {
            this.fileToOpen = project.findMember((IPath)new Path(fileToOpenPath));
        }
    }

    private void doImport(IPath destiny, String sourceZip, String zipRelativeDir, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            Bundle bundle = Platform.getBundle((String)this.projectWizardDefinition.getContributingBundle());
            URL url = new URL(bundle.getEntry("/"), sourceZip);
            ZipFile zipFile = new ZipFile(FileLocator.toFileURL((URL)url).getFile());
            ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
            Path zipRelativePath = new Path(zipRelativeDir);
            int zipInternalPathSegments = zipRelativePath.segmentCount();
            ZipEntry entry2 = structureProvider.getRoot();
            if (zipInternalPathSegments != 0) {
                int i = 1;
                while (i <= zipInternalPathSegments) {
                    for (ZipEntry entry2 : structureProvider.getChildren((Object)entry2)) {
                        String segments = zipRelativePath.uptoSegment(i).toString();
                        if (entry2.getName().equals(segments)) break;
                    }
                    ++i;
                }
            }
            if (!entry2.getName().equals(zipRelativeDir)) {
                Status status = new Status(4, "org.eclipse.ptp.cell.examples.ui", 4, String.valueOf(zipRelativeDir) + " doesn't exist in the example source zip file.", (Throwable)new Exception());
                throw new InvocationTargetException(new CoreException((IStatus)status));
            }
            ImportOperation op = new ImportOperation(destiny, (Object)entry2, (IImportStructureProvider)structureProvider, (IOverwriteQuery)new ImportOverwriteQuery());
            op.setCreateContainerStructure(false);
            op.run(monitor);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.ptp.cell.examples.ui", 4, String.valueOf(sourceZip) + "/" + zipRelativeDir + ": " + e.getMessage(), (Throwable)e);
            throw new InvocationTargetException(new CoreException((IStatus)status));
        }
    }

    private IProject getNewProjectOpened(IWorkspaceRoot root, String projectName, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IProject project = root.getProject(projectName);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            return project;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public IResource getFileToOpen() {
        return this.fileToOpen;
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        private int openDialog(final String file) {
            final int[] result = new int[]{1};
            ExampleProjectCreationOperation.this.wizardShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String title = ExampleMessages.overwriteQueryTitle;
                    String msg = ExampleMessages.bind((String)ExampleMessages.overwriteQueryMessage, (Object)file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ExampleProjectCreationOperation.this.wizardShell, title, null, msg, 3, options, 0);
                    result[0] = dialog.open();
                }
            });
            return result[0];
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }
    }
}

