/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.examples.ui.internal.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ptp.cell.examples.ui.internal.ExampleMessages;
import org.eclipse.ptp.cell.examples.ui.internal.ProjectWizardDefinition;
import org.eclipse.ptp.cell.examples.ui.internal.wizards.ExampleProjectCreationWizard;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ExampleProjectCreationWizardPage
extends WizardNewProjectCreationPage {
    private ProjectWizardDefinition projectWizardDefinition;
    private String initialProjectName;

    public ExampleProjectCreationWizardPage(ProjectWizardDefinition projectWizardDefinition) {
        super(projectWizardDefinition.getName());
        this.projectWizardDefinition = projectWizardDefinition;
        this.initialProjectName = projectWizardDefinition.getName();
        this.setTitle(projectWizardDefinition.getPageTitle());
        this.setDescription(projectWizardDefinition.getPageDescription());
        this.setInitialProjectName(this.initialProjectName);
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String projectName = this.getProjectName();
        if (projectName == null) {
            return false;
        }
        IWizard wizard = this.getWizard();
        if (wizard instanceof ExampleProjectCreationWizard) {
            IWizardPage[] pages = wizard.getPages();
            int i = 0;
            while (i < pages.length) {
                if (pages[i] != this && pages[i] instanceof ExampleProjectCreationWizardPage && projectName.equals(((ExampleProjectCreationWizardPage)pages[i]).getProjectName())) {
                    this.setErrorMessage(ExampleMessages.wizardPageErrorAlreadyExists);
                    return false;
                }
                ++i;
            }
            if (!this.getProjectName().equals(this.initialProjectName)) {
                this.setMessage(ExampleMessages.wizardPageWarningNameChanged);
            }
        }
        return true;
    }

    public ProjectWizardDefinition getProjectWizardDefinition() {
        return this.projectWizardDefinition;
    }
}

