/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.environment.PTPTargetControl;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;

public class RemoteToolsConnectionManager
implements IRemoteConnectionManager {
    private final ListenerList listeners = new ListenerList();
    private TargetTypeElement remoteHost = null;
    private Map<String, IRemoteConnection> connections = new HashMap<String, IRemoteConnection>();

    public RemoteToolsConnectionManager() {
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        for (Object obj : targetMgr.getTypeElements()) {
            TargetTypeElement element = (TargetTypeElement)obj;
            if (!element.getName().equals("Remote Host")) continue;
            this.remoteHost = element;
            break;
        }
        this.refreshConnections();
    }

    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void fireConnectionChangeEvent(IRemoteConnectionChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }

    public IRemoteConnection getConnection(String name) {
        this.refreshConnections();
        return this.connections.get(name);
    }

    public IRemoteConnection[] getConnections() {
        this.refreshConnections();
        return this.connections.values().toArray(new IRemoteConnection[this.connections.size()]);
    }

    public void removeConnection(IRemoteConnection conn) {
        this.connections.remove(conn);
    }

    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void refreshConnections() {
        HashMap<String, IRemoteConnection> newConns = new HashMap<String, IRemoteConnection>();
        for (Object obj : this.remoteHost.getElements()) {
            ITargetElement element = (ITargetElement)obj;
            IRemoteConnection conn = this.connections.get(element.getName());
            if (conn == null) {
                try {
                    ITargetControl control = element.getControl();
                    String address = (String)element.getAttributes().get("ptp.connection-address");
                    String user = (String)element.getAttributes().get("ptp.login-username");
                    conn = new RemoteToolsConnection(element.getName(), address, user, (PTPTargetControl)control);
                    ((PTPTargetControl)control).setConnection(this, conn);
                }
                catch (CoreException coreException) {}
            }
            newConns.put(element.getName(), conn);
        }
        this.connections = newConns;
    }
}

