/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.cell.sputiming.extension.ISPUTimingObserver;
import org.eclipse.ptp.cell.sputiming.ui.Activator;
import org.eclipse.ptp.cell.sputiming.ui.debug.Debug;
import org.eclipse.ptp.cell.sputiming.ui.message.Messages;
import org.eclipse.ptp.cell.sputiming.ui.parse.ParsedTimingFile;
import org.eclipse.ptp.cell.sputiming.ui.parse.TimingFileParser;

public class SPUTimingObserver
implements ISPUTimingObserver {
    public void afterFileGeneration(IPath filename) {
        Debug.read();
        Debug.POLICY.trace(Debug.DEBUG_NOTIFICATIONS, "Received notification: ''{0}''", new Object[]{filename.toString()});
        TimingFileParser timingFileParser = new TimingFileParser(filename.toOSString());
        ParsedTimingFile parsedTiming = null;
        try {
            parsedTiming = timingFileParser.parseTimingFile();
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_NOTIFICATIONS, "Failed to parse file: ''{0}''", new Object[]{filename.toOSString()});
            Debug.POLICY.error((Throwable)e);
            Debug.POLICY.logError((Throwable)e, Messages.SPUTimingObserver_FailedParseFile, new Object[]{filename.toOSString()});
            parsedTiming = null;
            return;
        }
        Debug.POLICY.trace(Debug.DEBUG_NOTIFICATIONS, "sputiming file parsed sucessfully", new Object[]{filename.toString()});
        Activator.getDefault().setTiming(parsedTiming);
        Debug.POLICY.trace(Debug.DEBUG_NOTIFICATIONS, "Requested to update GUI", new Object[]{filename.toString()});
    }
}

