/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ptp.cell.debug.launch.CellDebugRemoteDebugger;
import org.eclipse.ptp.cell.debug.launch.ICellDebugLaunchRemoteDebugConfiguration;
import org.eclipse.ptp.utils.core.extensionpoints.IProcessMemberVisitor;
import org.eclipse.ptp.utils.core.extensionpoints.ProcessExtensions;
import org.osgi.framework.BundleContext;

public class CellDebugPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.cell.debug.core";
    public static final String EXT_REMOTE_DGB_ID = "org.eclipse.ptp.cell.debug.core.CellRemoteDebugger";
    private static CellDebugPlugin plugin;

    public CellDebugPlugin() {
        plugin = this;
    }

    private Map getRemoteDbgConfigs() {
        final HashMap configs = new HashMap();
        ProcessExtensions.process((String)EXT_REMOTE_DGB_ID, (IProcessMemberVisitor)new IProcessMemberVisitor(){

            public Object process(IExtension extension, IConfigurationElement member) {
                Object mprovider;
                try {
                    mprovider = member.createExecutableExtension("class");
                    if (ICellDebugLaunchRemoteDebugConfiguration.class.isAssignableFrom(mprovider.getClass())) {
                        String name = member.getAttribute("name");
                        String dbgId = member.getAttribute("debuggerId");
                        CellDebugRemoteDebugger dbg = new CellDebugRemoteDebugger();
                        dbg.setDebugConfig((ICellDebugLaunchRemoteDebugConfiguration)mprovider);
                        dbg.setDebuggerId(dbgId);
                        dbg.setName(name);
                        configs.put(name, dbg);
                    }
                }
                catch (CoreException coreException) {
                    mprovider = null;
                }
                return mprovider;
            }
        });
        return configs;
    }

    public String[] getRemoteDbgNames() {
        Map configs = this.getRemoteDbgConfigs();
        ArrayList<String> names = new ArrayList<String>();
        for (String name : configs.keySet()) {
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    public CellDebugRemoteDebugger getRemoteDbgConfigByName(String name) {
        Map configs = this.getRemoteDbgConfigs();
        return (CellDebugRemoteDebugger)configs.get(name);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.savePluginPreferences();
        plugin = null;
        super.stop(context);
    }

    public static CellDebugPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }
}

