/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.callhierarchy;

import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.opentype.ElementSelectionDialog;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.CallHierarchyUtil;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenElementInCallHierarchyAction
implements IWorkbenchWindowActionDelegate {
    private static final int[] VISIBLE_TYPES = new int[]{74, 70, 76, 81, 73, 71, 77};
    private IWorkbenchWindow fWorkbenchWindow;

    public void run(IAction action) {
        ElementSelectionDialog dialog = new ElementSelectionDialog(this.getShell());
        this.configureDialog(dialog);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        ICElement[] elements = null;
        ITypeReference location = info.getResolvedReference();
        if (location != null) {
            elements = location.getCElements();
        }
        if (elements == null || elements.length == 0) {
            String title = CHMessages.OpenElementInCallHierarchyAction_errorDlgTitle;
            String message = NLS.bind((String)CHMessages.OpenElementInCallHierarchyAction_errorNoDefinition, (Object)info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            elements[0].getCProject().getProject();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(elements[0].getCProject().getProject());
            IService indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService");
            IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService);
            if (serviceProvider instanceof IIndexServiceProvider) {
                ICallHierarchyService chService = ((IIndexServiceProvider)serviceProvider).getCallHierarchyService();
                CallHierarchyUtil.open(chService, this.fWorkbenchWindow, elements[0]);
            }
        }
    }

    private void configureDialog(ElementSelectionDialog dialog) {
        String txt;
        ISelection sel;
        IWorkbenchPart part;
        IWorkbenchPage page;
        dialog.setDialogSettings(this.getClass().getName());
        dialog.setVisibleTypes(VISIBLE_TYPES);
        dialog.setTitle(CHMessages.OpenElementInCallHierarchyAction_title);
        dialog.setUpperListLabel(CHMessages.OpenElementInCallHierarchyAction_upperListLabel);
        dialog.setMessage(CHMessages.OpenElementInCallHierarchyAction_message);
        if (this.fWorkbenchWindow != null && (page = this.fWorkbenchWindow.getActivePage()) != null && (part = page.getActivePart()) instanceof ITextEditor && (sel = ((ITextEditor)part).getSelectionProvider().getSelection()) instanceof ITextSelection && (txt = ((ITextSelection)sel).getText()).length() > 0 && txt.length() < 80) {
            dialog.setFilter(txt, true);
        }
    }

    private Shell getShell() {
        return this.fWorkbenchWindow.getShell();
    }

    public void dispose() {
        this.fWorkbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

