/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.LocalDefaultValues;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalLaunchAutomaticAttributeGenerator;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;

public class LocalConfigurationBean
extends CommonConfigurationBean {
    private String pluginId = null;
    public static final String ATTR_PREFERENCES_PREFIX = "local-";
    public static final String AUTOMATIC_WORK_DIRECTORY = "automatic-work-directory";
    protected static final String[] SPECIFIC_KEY_ARRAY = new String[]{"automatic-work-directory"};
    protected static final String[] SPECIFIC_KEY_CIPHERED_ARRAY = new String[0];
    public static final String[] KEY_ARRAY;
    public static final String[] KEY_CIPHERED_ARRAY;

    static {
        Vector<String> list = new Vector<String>(Arrays.asList(CommonConfigurationBean.SPECIFIC_KEY_ARRAY));
        list.addAll(Arrays.asList(SPECIFIC_KEY_ARRAY));
        KEY_ARRAY = list.toArray(new String[list.size()]);
        list = new Vector<String>(Arrays.asList(CommonConfigurationBean.SPECIFIC_KEY_CIPHERED_ARRAY));
        list.addAll(Arrays.asList(SPECIFIC_KEY_CIPHERED_ARRAY));
        KEY_CIPHERED_ARRAY = list.toArray(new String[list.size()]);
    }

    public LocalConfigurationBean() {
        this.createAutomaticConfiguration();
    }

    public LocalConfigurationBean(Map newMap, String pluginId) {
        super(newMap);
        this.createAutomaticConfiguration();
        this.pluginId = pluginId;
    }

    protected void createDefaultMap() {
        super.createDefaultMap();
        this.defaultMap.put("work-directory", LocalDefaultValues.WORK_DIRECTORY);
        this.defaultMap.put(AUTOMATIC_WORK_DIRECTORY, LocalDefaultValues.AUTOMATIC_WORK_DIRECTORY);
        this.defaultMap.put("show-simulator-gui", LocalDefaultValues.SHOW_SIMULATOR_GUI);
        this.defaultMap.put("console-show-linux", LocalDefaultValues.CONSOLE_SHOW_LINUX);
        this.defaultMap.put("console-show-simulator", LocalDefaultValues.CONSOLE_SHOW_SIMULATOR);
        this.defaultMap.put("automatic-network", LocalDefaultValues.AUTOMATIC_NETWORK);
        this.defaultMap.put("ip-host", LocalDefaultValues.IP_HOST);
        this.defaultMap.put("ip-simulator", LocalDefaultValues.IP_SIMULATOR);
        this.defaultMap.put("mac-simulator", LocalDefaultValues.MAC_SIMULATOR);
        this.defaultMap.put("automatic-portconfig", LocalDefaultValues.AUTOMATIC_PORTCONFIG);
        this.defaultMap.put("java-api-socket-port", LocalDefaultValues.JAVA_API_SOCKET_PORT);
        this.defaultMap.put("console-socket-port", LocalDefaultValues.CONSOLE_SOCKET_PORT);
        this.defaultMap.put("system-workspace-dir", LocalDefaultValues.SYSTEM_WORKSPACE);
    }

    protected void createCurrentMapFromPreferences() {
        super.createCurrentMapFromPreferences();
        IPreferenceStore store = CellSimulatorTargetPlugin.getDefault().getPreferenceStore();
        this.currentMap.put("show-simulator-gui", store.getString("local-show-simulator-gui"));
        this.currentMap.put("console-show-linux", store.getString("local-console-show-linux"));
        this.currentMap.put("console-show-simulator", store.getString("local-console-show-simulator"));
        this.currentMap.put("simulator-base-directory", store.getString("local-simulator-base-directory"));
        this.currentMap.put("work-directory", store.getString("local-work-directory"));
        this.currentMap.put("root-image-path", store.getString("local-root-image-path"));
        this.currentMap.put("kernel-image-path", store.getString("local-kernel-image-path"));
        this.currentMap.put("system-workspace-dir", store.getString("local-system-workspace-dir"));
    }

    protected void createAutomaticConfiguration() {
        if (this.currentMap.containsKey("core-environmentid")) {
            return;
        }
        String targetID = EnvironmentPlugin.getDefault().getEnvironmentUniqueID();
        this.currentMap.put("core-environmentid", targetID);
        LocalLaunchAutomaticAttributeGenerator generator = LocalLaunchAutomaticAttributeGenerator.getAutomaticAttributeGenerator();
        if (LocalDefaultValues.doAutomaticNetworkConfig()) {
            String ipSimulator = generator.getSimulatorAddress(targetID);
            String ipHost = generator.getHostAddress(targetID);
            String macSimulator = generator.getMacAddress(targetID);
            this.currentMap.put("ip-host", ipHost);
            this.currentMap.put("ip-simulator", ipSimulator);
            this.currentMap.put("mac-simulator", macSimulator);
        } else {
            this.currentMap.put("ip-host", LocalDefaultValues.IP_HOST);
            this.currentMap.put("ip-simulator", LocalDefaultValues.IP_SIMULATOR);
            this.currentMap.put("mac-simulator", LocalDefaultValues.MAC_SIMULATOR);
        }
        if (LocalDefaultValues.doAutomaticPortConfig()) {
            int javaApiPort = generator.getJavaAPIPort(targetID);
            int consolePort = generator.getAnotherConsolePort(targetID);
            this.currentMap.put("java-api-socket-port", Integer.toString(javaApiPort));
            this.currentMap.put("console-socket-port", Integer.toString(consolePort));
        } else {
            this.currentMap.put("java-api-socket-port", LocalDefaultValues.JAVA_API_SOCKET_PORT);
            this.currentMap.put("console-socket-port", LocalDefaultValues.CONSOLE_SOCKET_PORT);
        }
    }

    public CommonConfigFactory createFactory() {
        return new LocalConfigFactory(this, this.pluginId);
    }
}

