/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.cellbe.internal.integration;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.cell.debug.launch.ICellDebugLaunchConstants;
import org.eclipse.ptp.cell.debug.launch.LocalCellCDILaunchDelegate;
import org.eclipse.ptp.cell.environment.launcher.cellbe.RemoteTargetLauncherPlugin;
import org.eclipse.ptp.cell.environment.launcher.cellbe.debug.Debug;
import org.eclipse.ptp.cell.environment.launcher.cellbe.internal.integration.Messages;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.core.NullLaunchIntegration;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class DebugIntegration
extends NullLaunchIntegration
implements ILaunchIntegration {
    LocalCellCDILaunchDelegate debugDelegate = new LocalCellCDILaunchDelegate();
    IRemoteExecutionManager manager;
    private String mode;
    private ILaunchConfiguration config;
    private ILaunch launch;
    private IProgressMonitor monitor;
    private boolean doRemote = false;

    public DebugIntegration(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) {
        this.config = config;
        this.mode = mode;
        this.launch = launch;
        this.monitor = monitor;
    }

    public void setExecutionManager(IRemoteExecutionManager manager) {
        this.manager = manager;
    }

    public void start() throws CoreException {
        Set ports = null;
        try {
            ports = this.manager.getRemoteStatusTools().getRemotePortsInUse(0);
        }
        catch (RemoteConnectionException e) {
            throw new CoreException((IStatus)new Status(4, RemoteTargetLauncherPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
        }
        catch (RemoteOperationException e) {
            throw new CoreException((IStatus)new Status(4, RemoteTargetLauncherPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
        }
        catch (CancelException cancelException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (ports != null) {
            String gdbPort = this.config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, "0");
            Debug.POLICY.trace(Debug.DEBUG_INTEGRATION, "Checking if GDB port {0} is available,,,", new Object[]{gdbPort});
            if (ports.contains(new Integer(gdbPort))) {
                throw new CoreException((IStatus)new Status(4, RemoteTargetLauncherPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.getString("DebugIntegration.0"), null));
            }
        }
    }

    public String[] createLaunchScript(String applicationFullPath, String[] arguments) throws CoreException {
        ILaunchConfigurationWorkingCopy copy = this.config.getWorkingCopy();
        copy.setAttribute(ICellDebugLaunchConstants.TARGET_ENV_SELECTED, copy.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", ""));
        this.config = copy.doSave();
        String[] script = this.debugDelegate.getRemoteDebuggerCommand(this.config, applicationFullPath, arguments);
        if (Debug.DEBUG_INTEGRATION) {
            Debug.POLICY.trace("Launch script with GDB:");
            int i = 0;
            while (i < script.length) {
                String string = script[i];
                Debug.POLICY.trace(string);
                ++i;
            }
        }
        return script;
    }

    public boolean getDoLaunchApplication() throws CoreException {
        this.doRemote = this.debugDelegate.doRemoteLaunch(this.config);
        return this.doRemote;
    }

    public void finalizeLaunch() throws CoreException, CancelException {
        boolean portAvail = false;
        while (!portAvail && this.doRemote) {
            String gdbPort;
            Set ports = null;
            try {
                ports = this.manager.getRemoteStatusTools().getRemotePortsInUse(0);
            }
            catch (RemoteConnectionException e) {
                throw new CoreException((IStatus)new Status(4, RemoteTargetLauncherPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
            }
            catch (RemoteOperationException e) {
                throw new CoreException((IStatus)new Status(4, RemoteTargetLauncherPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
            }
            catch (CancelException cancelException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            if (ports != null && ports.contains(new Integer(gdbPort = this.config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, "0")))) {
                portAvail = true;
                Debug.POLICY.trace(Debug.DEBUG_INTEGRATION, "GDB is listening for connection,");
            }
            if (portAvail) continue;
            try {
                Debug.POLICY.trace(Debug.DEBUG_INTEGRATION, "GDB not yet is listening for connection, Wainting...");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.debugDelegate.launchIntegration(this.config, this.mode, this.launch, this.monitor);
    }
}

