/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import org.eclipse.ptp.remotetools.core.IPortForwarding;
import org.eclipse.ptp.remotetools.core.IRemotePortForwarding;
import org.eclipse.ptp.remotetools.core.IRemotePortForwardingTools;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.PortForwardingException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.RemotePortForwarding;

public class PortForwardingTools
implements IRemotePortForwardingTools {
    ExecutionManager executionManager;

    PortForwardingTools(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    public IRemotePortForwarding forwardRemotePort(int remotePort, int localPort) throws RemoteConnectionException, PortForwardingException, CancelException {
        this.executionManager.test();
        this.executionManager.testCancel();
        RemotePortForwarding forwarding = this.executionManager.connection.forwardingPool.createRemotePortForwarding(this.executionManager, remotePort, null, localPort);
        return forwarding;
    }

    public IRemotePortForwarding forwardRemotePort(int remotePort, String localAddress, int localPort) throws RemoteConnectionException, PortForwardingException, CancelException {
        this.executionManager.test();
        this.executionManager.testCancel();
        RemotePortForwarding forwarding = this.executionManager.connection.forwardingPool.createRemotePortForwarding(this.executionManager, remotePort, localAddress, localPort);
        return forwarding;
    }

    public IRemotePortForwarding getRemotePortForwarding(int remotePort) throws RemoteConnectionException, PortForwardingException {
        this.executionManager.test();
        RemotePortForwarding forwarding = this.executionManager.connection.forwardingPool.getRemotePortForwarding(remotePort);
        if (forwarding == null) {
            return null;
        }
        if (forwarding.owner != this.executionManager) {
            return null;
        }
        return forwarding;
    }

    public void releaseForwarding(IPortForwarding forwarding) throws RemoteConnectionException, PortForwardingException {
        assert (forwarding != null);
        this.executionManager.test();
        if (forwarding instanceof RemotePortForwarding) {
            this.executionManager.connection.forwardingPool.releaseRemotePortForwarding((RemotePortForwarding)forwarding, this.executionManager);
        } else assert (false);
    }
}

