/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.alf.ui.core.ALFBuffer;
import org.eclipse.ptp.cell.alf.ui.core.ALFBufferValidator;
import org.eclipse.ptp.cell.alf.ui.debug.Debug;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizard;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageB;
import org.eclipse.ptp.utils.ui.swt.ToolKit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ALFBufferDialog
extends Dialog
implements SelectionListener {
    private WizardPage parentPage;
    private ALFBuffer alfBuffer;
    private ALFBufferValidator validator;
    private String title;
    private Text bufferName;
    private Text elementType;
    private Combo elementUnit;
    private Combo bufferType;
    private Combo numDimensions;
    private Text dimensionSizeX;
    private Text dimensionSizeY;
    private Text dimensionSizeZ;
    private Combo distributionModelX;
    private Combo distributionModelY;
    private Combo distributionModelZ;
    private Text distributionSizeX;
    private Text distributionSizeY;
    private Text distributionSizeZ;
    private Text distributionModelHelpText;
    private Text errorMsgText;

    public ALFBufferDialog(Shell parentShell, String dialogTitle, ALFBuffer buffer, ALFBufferValidator bufferValidator, WizardPage parentPage) {
        super(parentShell);
        this.title = dialogTitle;
        this.validator = bufferValidator;
        this.alfBuffer = buffer;
        this.parentPage = parentPage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void create() {
        super.create();
        this.validateInput();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.bufferName = ToolKit.createTextWithLabel((Composite)composite, (String)Messages.ALFBufferDialog_variableNameLabelMessage, null, (int)0);
        this.elementType = ToolKit.createTextWithLabel((Composite)composite, (String)Messages.ALFBufferDialog_elementTypeLabelMessage, null, (int)0);
        Composite row = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        row.setLayout((Layout)layout2);
        row.setLayoutData((Object)new GridData(772));
        Label elementUnitLabel = new Label(row, 16448);
        elementUnitLabel.setLayoutData((Object)new GridData(36));
        elementUnitLabel.setFont(font);
        elementUnitLabel.setText(Messages.ALFBufferDialog_elementUnitLabelMessage);
        this.elementUnit = new Combo(row, 12);
        this.elementUnit.setLayoutData((Object)new GridData(132));
        this.elementUnit.setFont(font);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitByte, 0);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitInt16, 1);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitInt32, 2);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitInt64, 3);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitFloat, 4);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitDouble, 5);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitAddr32, 6);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitAddr64, 7);
        this.elementUnit.add(Messages.ALFBufferDialog_elementUnitType, 8);
        this.elementUnit.select(8);
        Composite row2 = new Composite(composite, 0);
        row2.setLayout((Layout)layout2);
        row2.setLayoutData((Object)new GridData(772));
        Label bufferTypeLabel = new Label(row2, 16448);
        bufferTypeLabel.setLayoutData((Object)new GridData(36));
        bufferTypeLabel.setFont(font);
        bufferTypeLabel.setText(String.valueOf(Messages.ALFBufferDialog_bufferTypeLabelMessage) + ':');
        this.bufferType = new Combo(row2, 12);
        this.bufferType.setLayoutData((Object)new GridData(132));
        this.bufferType.setFont(font);
        this.bufferType.add(Messages.ALFBufferDialog_bufferTypeInput, 0);
        this.bufferType.add(Messages.ALFBufferDialog_bufferTypeOutput, 1);
        this.bufferType.select(0);
        Composite row3 = new Composite(composite, 0);
        row3.setLayout((Layout)layout2);
        row3.setLayoutData((Object)new GridData(772));
        Label dimensionSizeLabel = new Label(row3, 16448);
        dimensionSizeLabel.setLayoutData((Object)new GridData(36));
        dimensionSizeLabel.setFont(font);
        dimensionSizeLabel.setText(String.valueOf(Messages.ALFBufferDialog_dimensionSizeLabelMessage) + ':');
        this.numDimensions = new Combo(row3, 12);
        this.numDimensions.setLayoutData((Object)new GridData(132));
        this.numDimensions.setFont(font);
        this.numDimensions.add(Messages.ALFBufferDialog_oneDimensionMessage, 0);
        this.numDimensions.add(Messages.ALFBufferDialog_twoDimensionMessage, 1);
        this.numDimensions.add(Messages.ALFBufferDialog_threeDimensionMessage, 2);
        this.numDimensions.select(0);
        Group dimensionSizeGroup = new Group(composite, 0);
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 1;
        dimensionSizeGroup.setLayout((Layout)layout1);
        dimensionSizeGroup.setLayoutData((Object)new GridData(772));
        dimensionSizeGroup.setText(String.valueOf(Messages.ALFBufferDialog_dimensionSizeGroupMessage) + ':');
        Composite dimensionSizeComposite = new Composite((Composite)dimensionSizeGroup, 0);
        GridLayout layout6 = new GridLayout();
        layout6.numColumns = 6;
        dimensionSizeComposite.setLayout((Layout)layout6);
        dimensionSizeComposite.setLayoutData((Object)new GridData(772));
        dimensionSizeComposite.setFont(font);
        this.dimensionSizeX = ToolKit.createTextWithLabel((Composite)dimensionSizeComposite, (String)Messages.ALFBufferDialog_XLabelMessage, (String)"0", (int)0);
        this.dimensionSizeX.setEnabled(true);
        this.dimensionSizeX.setEditable(true);
        this.dimensionSizeX.setText("1");
        this.dimensionSizeY = ToolKit.createTextWithLabel((Composite)dimensionSizeComposite, (String)Messages.ALFBufferDialog_YLabelMessage, (String)"0", (int)0);
        this.dimensionSizeY.setEnabled(false);
        this.dimensionSizeY.setEditable(true);
        this.dimensionSizeY.setText("1");
        this.dimensionSizeZ = ToolKit.createTextWithLabel((Composite)dimensionSizeComposite, (String)Messages.ALFBufferDialog_ZLabelMessage, (String)"0", (int)0);
        this.dimensionSizeZ.setEnabled(false);
        this.dimensionSizeZ.setEditable(true);
        this.dimensionSizeZ.setText("1");
        Group distributionGroup = new Group(composite, 0);
        distributionGroup.setLayout((Layout)layout1);
        distributionGroup.setLayoutData((Object)new GridData(772));
        distributionGroup.setText(String.valueOf(Messages.ALFBufferDialog_distributionModelGroupMessage) + ':');
        Composite distributionComposite = new Composite((Composite)distributionGroup, 0);
        distributionComposite.setLayout((Layout)layout6);
        distributionComposite.setLayoutData((Object)new GridData(772));
        Label distributionXLabel = new Label(distributionComposite, 16448);
        distributionXLabel.setLayoutData((Object)new GridData(36));
        distributionXLabel.setFont(font);
        distributionXLabel.setText(String.valueOf(Messages.ALFBufferDialog_XLabelMessage) + ':');
        this.distributionModelX = new Combo(distributionComposite, 12);
        this.distributionModelX.setLayoutData((Object)new GridData(132));
        this.distributionModelX.setFont(font);
        this.distributionModelX.add(Messages.ALFBufferDialog_distributionModelStar, 0);
        this.distributionModelX.add(Messages.ALFBufferDialog_distributionModelBlock, 1);
        this.distributionModelX.add(Messages.ALFBufferDialog_distributionModelCyclic, 2);
        this.distributionModelX.select(0);
        this.distributionModelX.setEnabled(true);
        Label distributionYLabel = new Label(distributionComposite, 16448);
        distributionYLabel.setLayoutData((Object)new GridData(36));
        distributionYLabel.setFont(font);
        distributionYLabel.setText(String.valueOf(Messages.ALFBufferDialog_YLabelMessage) + ':');
        this.distributionModelY = new Combo(distributionComposite, 12);
        this.distributionModelY.setLayoutData((Object)new GridData(132));
        this.distributionModelY.setFont(font);
        this.distributionModelY.add(Messages.ALFBufferDialog_distributionModelStar, 0);
        this.distributionModelY.add(Messages.ALFBufferDialog_distributionModelBlock, 1);
        this.distributionModelY.add(Messages.ALFBufferDialog_distributionModelCyclic, 2);
        this.distributionModelY.select(0);
        this.distributionModelY.setEnabled(false);
        Label distributionZLabel = new Label(distributionComposite, 16448);
        distributionZLabel.setLayoutData((Object)new GridData(36));
        distributionZLabel.setFont(font);
        distributionZLabel.setText(String.valueOf(Messages.ALFBufferDialog_ZLabelMessage) + ':');
        this.distributionModelZ = new Combo(distributionComposite, 12);
        this.distributionModelZ.setLayoutData((Object)new GridData(132));
        this.distributionModelZ.setFont(font);
        this.distributionModelZ.add(Messages.ALFBufferDialog_distributionModelStar, 0);
        this.distributionModelZ.add(Messages.ALFBufferDialog_distributionModelBlock, 1);
        this.distributionModelZ.select(0);
        this.distributionModelZ.setEnabled(false);
        this.distributionModelHelpText = ALFWizard.createWhatsThisHelpText((Composite)distributionGroup, this.getShell(), this.parentPage.getWizard(), "data/distribution_model_help.html", 570, 500);
        this.distributionModelHelpText.getShell();
        Group distributionSizeGroup = new Group(composite, 0);
        distributionSizeGroup.setLayout((Layout)layout1);
        distributionSizeGroup.setLayoutData((Object)new GridData(772));
        distributionSizeGroup.setText(String.valueOf(Messages.ALFBufferDialog_distributionSizeGroupMessage) + ':');
        Composite distributionSizeComposite = new Composite((Composite)distributionSizeGroup, 0);
        distributionSizeComposite.setLayout((Layout)layout6);
        distributionSizeComposite.setLayoutData((Object)new GridData(772));
        this.distributionSizeX = ToolKit.createTextWithLabel((Composite)distributionSizeComposite, (String)Messages.ALFBufferDialog_XLabelMessage, (String)"0", (int)0);
        this.distributionSizeX.setEnabled(true);
        this.distributionSizeX.setEditable(false);
        this.distributionSizeX.setText("1");
        this.distributionSizeY = ToolKit.createTextWithLabel((Composite)distributionSizeComposite, (String)Messages.ALFBufferDialog_YLabelMessage, (String)"0", (int)0);
        this.distributionSizeY.setEnabled(false);
        this.distributionSizeY.setEditable(false);
        this.distributionSizeY.setText("1");
        this.distributionSizeZ = ToolKit.createTextWithLabel((Composite)distributionSizeComposite, (String)Messages.ALFBufferDialog_ZLabelMessage, (String)"0", (int)0);
        this.distributionSizeZ.setEnabled(false);
        this.distributionSizeZ.setEditable(false);
        this.distributionSizeZ.setText("1");
        this.errorMsgText = new Text(composite, 72);
        GridData errorData = new GridData(1296);
        errorData.minimumHeight = 85;
        this.errorMsgText.setLayoutData((Object)errorData);
        this.errorMsgText.setBackground(this.errorMsgText.getDisplay().getSystemColor(22));
        Color errorMsgColor = new Color(font.getDevice(), new RGB(255, 0, 0));
        this.errorMsgText.setFont(font);
        this.errorMsgText.setForeground(errorMsgColor);
        if (this.alfBuffer != null) {
            this.populateFields();
        }
        this.bufferName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ALFBufferDialog.this.validateInput();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.elementType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ALFBufferDialog.this.validateInput();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.elementUnit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    ALFBufferDialog.this.validateInput();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.numDimensions.addSelectionListener((SelectionListener)this);
        this.dimensionSizeX.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ALFBufferDialog.this.distributionModelX.getSelectionIndex() == 0 || ALFBufferDialog.this.distributionModelX.getSelectionIndex() == 1) {
                        ALFBufferDialog.this.distModelChanged((Widget)ALFBufferDialog.this.distributionModelX);
                    }
                    ALFBufferDialog.this.validateInput();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.dimensionSizeY.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ALFBufferDialog.this.distributionModelY.getSelectionIndex() == 0 || ALFBufferDialog.this.distributionModelY.getSelectionIndex() == 1) {
                        ALFBufferDialog.this.distModelChanged((Widget)ALFBufferDialog.this.distributionModelY);
                    }
                    ALFBufferDialog.this.validateInput();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.dimensionSizeZ.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ALFBufferDialog.this.distributionModelZ.getSelectionIndex() == 0 || ALFBufferDialog.this.distributionModelZ.getSelectionIndex() == 1) {
                        ALFBufferDialog.this.distModelChanged((Widget)ALFBufferDialog.this.distributionModelZ);
                    }
                    ALFBufferDialog.this.validateInput();
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.distributionModelX.addSelectionListener((SelectionListener)this);
        this.distributionModelY.addSelectionListener((SelectionListener)this);
        this.distributionModelZ.addSelectionListener((SelectionListener)this);
        this.distributionSizeX.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ALFBufferDialog.this.distributionModelX.getSelectionIndex() == 2) {
                        ALFBufferDialog.this.validateInput();
                    }
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        this.distributionSizeY.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ALFBufferDialog.this.distributionModelY.getSelectionIndex() == 2) {
                        ALFBufferDialog.this.validateInput();
                    }
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        return composite;
    }

    public ALFBuffer getBuffer() {
        return this.alfBuffer;
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        Button button = this.getButton(0);
        this.validateInput();
        if (!button.isEnabled()) {
            return;
        }
        String name = this.bufferName.getText().trim();
        if (name == null || name.length() == 0) {
            this.setErrorMessage(Messages.ALFBufferDialog_errorMsgBufferName);
            return;
        }
        String type = this.elementType.getText().trim();
        if (type == null || type.length() == 0) {
            this.setErrorMessage(Messages.ALFBufferDialog_errorMsgElementType);
            return;
        }
        ALFWizardPageB pageB = (ALFWizardPageB)this.parentPage;
        String aligned = ALFBufferValidator.is16ByteAligned(type, this.numDimensions.getSelectionIndex(), Long.parseLong(this.distributionSizeX.getText().trim()), Long.parseLong(this.distributionSizeY.getText().trim()), Long.parseLong(this.distributionSizeZ.getText().trim()), pageB.is64bit());
        if (aligned != null) {
            final MessageDialog dialog = new MessageDialog(this.getShell(), this.title, null, aligned, 3, new String[]{Messages.ALFWizard_yes, Messages.ALFWizard_no}, 0);
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            int returnCode = dialog.getReturnCode();
            if (returnCode == 1) {
                return;
            }
        }
        if (this.alfBuffer == null) {
            this.alfBuffer = new ALFBuffer(this.bufferName.getText().trim(), this.elementType.getText().trim(), this.elementUnit.getSelectionIndex(), this.bufferType.getSelectionIndex(), this.numDimensions.getSelectionIndex(), Long.parseLong(this.dimensionSizeX.getText().trim()), Long.parseLong(this.dimensionSizeY.getText().trim()), Long.parseLong(this.dimensionSizeZ.getText().trim()), this.distributionModelX.getSelectionIndex(), this.distributionModelY.getSelectionIndex(), this.distributionModelZ.getSelectionIndex(), Long.parseLong(this.distributionSizeX.getText().trim()), Long.parseLong(this.distributionSizeY.getText().trim()), Long.parseLong(this.distributionSizeZ.getText().trim()), true);
        } else {
            this.alfBuffer.setName(this.bufferName.getText());
            this.alfBuffer.setElementType(this.elementType.getText());
            this.alfBuffer.setElementUnit(this.elementUnit.getSelectionIndex());
            this.alfBuffer.setBufferType(this.bufferType.getSelectionIndex());
            this.alfBuffer.setNumDimensions(this.numDimensions.getSelectionIndex());
            this.alfBuffer.setDimensionSizeX(Long.parseLong(this.dimensionSizeX.getText()));
            this.alfBuffer.setDimensionSizeY(Long.parseLong(this.dimensionSizeY.getText()));
            this.alfBuffer.setDimensionSizeZ(Long.parseLong(this.dimensionSizeZ.getText()));
            this.alfBuffer.setDistributionModelX(this.distributionModelX.getSelectionIndex());
            this.alfBuffer.setDistributionModelY(this.distributionModelY.getSelectionIndex());
            this.alfBuffer.setDistributionModelZ(this.distributionModelZ.getSelectionIndex());
            this.alfBuffer.setDistributionSizeX(Long.parseLong(this.distributionSizeX.getText()));
            this.alfBuffer.setDistributionSizeY(Long.parseLong(this.distributionSizeY.getText()));
            this.alfBuffer.setDistributionSizeZ(Long.parseLong(this.distributionSizeZ.getText()));
            this.alfBuffer.setIsValid(true);
        }
        this.setReturnCode(0);
        this.close();
    }

    private void populateFields() {
        if (this.alfBuffer == null) {
            return;
        }
        this.bufferName.setText(this.alfBuffer.getName());
        this.elementType.setText(this.alfBuffer.getElementType());
        this.elementUnit.select(this.alfBuffer.getElementUnit());
        this.bufferType.select(this.alfBuffer.getBufferType());
        this.numDimensions.select(this.alfBuffer.getNumDimensions());
        this.dimensionSizeX.setText(String.valueOf(this.alfBuffer.getDimensionSizeX()));
        this.dimensionSizeY.setText(String.valueOf(this.alfBuffer.getDimensionSizeY()));
        this.dimensionSizeZ.setText(String.valueOf(this.alfBuffer.getDimensionSizeZ()));
        this.distributionModelX.select(this.alfBuffer.getDistributionModelX());
        this.distributionModelY.select(this.alfBuffer.getDistributionModelY());
        this.distributionModelZ.select(this.alfBuffer.getDistributionModelZ());
        this.distributionSizeX.setText(String.valueOf(this.alfBuffer.getDistributionSizeX()));
        this.distributionSizeY.setText(String.valueOf(this.alfBuffer.getDistributionSizeY()));
        this.distributionSizeZ.setText(String.valueOf(this.alfBuffer.getDistributionSizeZ()));
        switch (this.alfBuffer.getNumDimensions()) {
            case 2: {
                this.dimensionSizeZ.setEnabled(true);
                this.distributionModelZ.setEnabled(true);
                this.distributionSizeZ.setEnabled(true);
                if (this.distributionModelZ.getSelectionIndex() == 2) {
                    this.distributionSizeZ.setEditable(true);
                }
            }
            case 1: {
                this.dimensionSizeY.setEnabled(true);
                this.distributionModelY.setEnabled(true);
                this.distributionSizeY.setEnabled(true);
                if (this.distributionModelY.getSelectionIndex() == 2) {
                    this.distributionSizeY.setEditable(true);
                }
            }
            case 0: {
                this.dimensionSizeX.setEnabled(true);
                this.distributionModelX.setEnabled(true);
                this.distributionSizeX.setEnabled(true);
                if (this.distributionModelX.getSelectionIndex() != 2) break;
                this.distributionSizeX.setEditable(true);
            }
        }
    }

    public void setErrorMessage(String errorMessage) {
        if (this.errorMsgText != null && !this.errorMsgText.isDisposed()) {
            this.errorMsgText.setText(errorMessage == null ? "" : errorMessage);
            this.errorMsgText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                if (errorMessage != null && errorMessage.length() >= 9) {
                    String messageType = errorMessage.substring(0, 9);
                    if (messageType.equalsIgnoreCase(Messages.ALFBufferValidator_warningMsg)) {
                        button.setEnabled(true);
                    } else {
                        button.setEnabled(false);
                    }
                } else {
                    button.setEnabled(errorMessage == null);
                }
            }
        }
    }

    protected void validateInput() {
        this.setErrorMessage(this.validator.isValid(this.bufferName.getText().trim(), this.elementType.getText().trim(), this.elementUnit.getSelectionIndex(), this.bufferType.getSelectionIndex(), this.numDimensions.getSelectionIndex(), this.dimensionSizeX.getText().trim(), this.dimensionSizeY.getText().trim(), this.dimensionSizeZ.getText().trim(), this.distributionModelX.getSelectionIndex(), this.distributionModelY.getSelectionIndex(), this.distributionModelZ.getSelectionIndex(), this.distributionSizeX.getText().trim(), this.distributionSizeY.getText().trim(), this.distributionSizeZ.getText().trim()));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            Widget source = e.widget;
            if (source == this.numDimensions) {
                this.numDimensionsChanged();
            }
            if (source == this.distributionModelX || source == this.distributionModelY || source == this.distributionModelZ) {
                this.distModelChanged(source);
            }
            if (source == this.dimensionSizeX) {
                this.distModelChanged((Widget)this.distributionModelX);
            } else if (source == this.dimensionSizeY) {
                this.distModelChanged((Widget)this.distributionModelY);
            } else if (source == this.dimensionSizeZ) {
                this.distModelChanged((Widget)this.distributionModelZ);
            }
            this.validateInput();
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }

    private void numDimensionsChanged() {
        if (this.numDimensions.getSelectionIndex() == 0) {
            this.dimensionSizeY.setEnabled(false);
            this.dimensionSizeZ.setEnabled(false);
            this.distributionModelY.setEnabled(false);
            this.distributionModelZ.setEnabled(false);
            this.distributionSizeY.setEnabled(false);
            this.distributionSizeZ.setEnabled(false);
        } else if (this.numDimensions.getSelectionIndex() == 1) {
            this.dimensionSizeY.setEnabled(true);
            this.dimensionSizeZ.setEnabled(false);
            this.distributionModelY.setEnabled(true);
            this.distributionModelZ.setEnabled(false);
            this.distributionSizeY.setEnabled(true);
            this.distributionSizeZ.setEnabled(false);
        } else if (this.numDimensions.getSelectionIndex() == 2) {
            this.dimensionSizeY.setEnabled(true);
            this.dimensionSizeZ.setEnabled(true);
            this.distributionModelY.setEnabled(true);
            this.distributionModelZ.setEnabled(true);
            this.distributionSizeY.setEnabled(true);
            this.distributionSizeZ.setEnabled(true);
        }
    }

    private void distModelChanged(Widget source) {
        int expAccelNum = this.validator.getExpectedAccelNum();
        if (source == this.distributionModelX) {
            if (this.distributionModelX.getSelectionIndex() == 0) {
                this.distributionSizeX.setText(this.dimensionSizeX.getText());
                this.distributionSizeX.setEditable(false);
            } else if (this.distributionModelX.getSelectionIndex() == 1) {
                long dimSizeX = Long.parseLong(this.dimensionSizeX.getText().trim());
                if (expAccelNum != 0 && dimSizeX > 0L) {
                    long newDistributionSizeX = dimSizeX / (long)expAccelNum;
                    this.distributionSizeX.setText(String.valueOf(newDistributionSizeX));
                } else {
                    this.distributionSizeX.setText("0");
                }
                this.distributionSizeX.setEditable(false);
            } else if (this.distributionModelX.getSelectionIndex() == 2) {
                this.distributionSizeX.setText("1");
                this.distributionSizeX.setEditable(true);
            }
        } else if (source == this.distributionModelY) {
            if (this.distributionModelY.getSelectionIndex() == 0) {
                this.distributionSizeY.setText(this.dimensionSizeY.getText());
                this.distributionSizeY.setEditable(false);
            } else if (this.distributionModelY.getSelectionIndex() == 1) {
                long dimSizeY = Long.parseLong(this.dimensionSizeY.getText().trim());
                if (expAccelNum != 0 && dimSizeY > 0L) {
                    long newDistributionSizeY = dimSizeY / (long)expAccelNum;
                    this.distributionSizeY.setText(String.valueOf(newDistributionSizeY));
                } else {
                    this.distributionSizeY.setText("0");
                }
                this.distributionSizeY.setEditable(false);
            } else if (this.distributionModelY.getSelectionIndex() == 2) {
                this.distributionSizeY.setText("1");
                this.distributionSizeY.setEditable(true);
            }
        } else if (source == this.distributionModelZ) {
            if (this.distributionModelZ.getSelectionIndex() == 0) {
                this.distributionSizeZ.setText(this.dimensionSizeZ.getText());
                this.distributionSizeZ.setEditable(false);
            } else if (this.distributionModelZ.getSelectionIndex() == 1) {
                if (expAccelNum != 0) {
                    long newDistributionSizeZ = Long.parseLong(this.dimensionSizeZ.getText()) / (long)expAccelNum;
                    this.distributionSizeZ.setText(String.valueOf(newDistributionSizeZ));
                } else {
                    this.distributionSizeZ.setText("0");
                }
                this.distributionSizeZ.setEditable(false);
            }
        }
    }
}

