/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCBasicType
extends PDOMNode
implements ICBasicType,
IIndexType {
    public static final int TYPE_ID = 8;
    public static final int FLAGS = 10;
    public static final int RECORD_SIZE = 12;
    public static final int IS_LONG = 1;
    public static final int IS_SHORT = 2;
    public static final int IS_UNSIGNED = 4;
    public static final int IS_SIGNED = 8;
    public static final int IS_LONGLONG = 16;
    public static final int IS_IMAGINARY = 32;
    public static final int IS_COMPLEX = 64;

    public PDOMCBasicType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCBasicType(PDOM pdom, PDOMNode parent, ICBasicType type) throws CoreException {
        super(pdom, parent);
        try {
            Database db = pdom.getDB();
            db.putChar(this.record + 8, (char)type.getType());
            char flags = '\u0000';
            if (type.isLong()) {
                flags = (char)(flags | 1);
            }
            if (type.isShort()) {
                flags = (char)(flags | 2);
            }
            if (type.isSigned()) {
                flags = (char)(flags | 8);
            }
            if (type.isUnsigned()) {
                flags = (char)(flags | 4);
            }
            if (type.isLongLong()) {
                flags = (char)(flags | 0x10);
            }
            if (type.isImaginary()) {
                flags = (char)(flags | 0x20);
            }
            if (type.isComplex()) {
                flags = (char)(flags | 0x40);
            }
            db.putChar(this.record + 10, flags);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    protected int getRecordSize() {
        return 12;
    }

    public int getNodeType() {
        return 14;
    }

    public int getType() {
        try {
            return this.pdom.getDB().getChar(this.record + 8);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return 0;
        }
    }

    public IASTExpression getValue() throws DOMException {
        return null;
    }

    public boolean isLong() throws DOMException {
        return this.flagSet(1);
    }

    public boolean isShort() throws DOMException {
        return this.flagSet(2);
    }

    public boolean isSigned() throws DOMException {
        return this.flagSet(8);
    }

    public boolean isUnsigned() throws DOMException {
        return this.flagSet(4);
    }

    public boolean isLongLong() throws DOMException {
        return this.flagSet(16);
    }

    public boolean isImaginary() {
        return this.flagSet(32);
    }

    public boolean isComplex() {
        return this.flagSet(64);
    }

    public boolean isSameType(IType rhs) {
        ICBasicType rhs1;
        block5: {
            if (rhs instanceof ITypedef) {
                return rhs.isSameType(this);
            }
            if (!(rhs instanceof ICBasicType)) {
                return false;
            }
            rhs1 = (ICBasicType)rhs;
            try {
                int type = this.getType();
                if (type != -1 && type == rhs1.getType()) break block5;
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return rhs1.getType() == this.getType() && rhs1.isLong() == this.isLong() && rhs1.isShort() == this.isShort() && rhs1.isSigned() == this.isSigned() && rhs1.isUnsigned() == this.isUnsigned() && rhs1.isLongLong() == this.isLongLong() && rhs1.isComplex() == this.isComplex() && rhs1.isImaginary() == this.isImaginary();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private char getFlags() throws CoreException {
        return this.pdom.getDB().getChar(this.record + 10);
    }

    private boolean flagSet(int flag) {
        try {
            return (this.getFlags() & flag) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }
}

