/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.core.runtime.CoreException;

public class DeclaredBindingsFilter
extends IndexFilter {
    private final int fLinkageID;
    private final boolean fAcceptImplicit;
    private final boolean fAcceptSpecializations;

    public DeclaredBindingsFilter() {
        this(-1, false);
    }

    public DeclaredBindingsFilter(int linkageID, boolean acceptImplicit) {
        this(linkageID, acceptImplicit, acceptImplicit);
    }

    public DeclaredBindingsFilter(int linkageID, boolean acceptImplicit, boolean acceptSpecializations) {
        this.fLinkageID = linkageID;
        this.fAcceptImplicit = acceptImplicit;
        this.fAcceptSpecializations = acceptSpecializations;
    }

    public boolean acceptLinkage(ILinkage linkage) {
        return this.fLinkageID == -1 || this.fLinkageID == linkage.getLinkageID();
    }

    public boolean acceptBinding(IBinding binding) throws CoreException {
        if (binding instanceof IIndexFragmentBinding) {
            return ((IIndexFragmentBinding)binding).hasDeclaration() || this.fAcceptImplicit && this.isImplicit(binding) || this.fAcceptSpecializations && binding instanceof ICPPSpecialization;
        }
        return this.fAcceptImplicit || !this.isImplicit(binding);
    }

    private boolean isImplicit(IBinding binding) {
        if (binding instanceof ICPPMethod) {
            return ((ICPPMethod)binding).isImplicit();
        }
        return false;
    }
}

