/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.index.IIndexCBindingConstants;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositeScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCBasicType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumeration;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCField;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunction;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCTypedef;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCVariable;
import org.eclipse.core.runtime.CoreException;

class PDOMCLinkage
extends PDOMLinkage
implements IIndexCBindingConstants {
    public PDOMCLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCLinkage(PDOM pdom) throws CoreException {
        super(pdom, "C", "C".toCharArray());
    }

    public int getNodeType() {
        return 0;
    }

    public String getLinkageName() {
        return "C";
    }

    public int getLinkageID() {
        return 2;
    }

    private PDOMBinding addBinding(IBinding inputBinding, IASTName fromName) throws CoreException {
        if (this.cannotAdapt(inputBinding)) {
            return null;
        }
        PDOMBinding pdomBinding = this.attemptFastAdaptBinding(inputBinding);
        if (pdomBinding == null) {
            IBinding binding = PDOMASTAdapter.getAdapterForAnonymousASTBinding(inputBinding);
            if (binding == null) {
                return null;
            }
            PDOMNode parent = this.getAdaptedParent(binding);
            if (parent == null) {
                return null;
            }
            pdomBinding = this.adaptBinding(parent, binding);
            if (pdomBinding == null) {
                pdomBinding = this.createBinding(parent, binding);
                if (pdomBinding != null) {
                    this.pdom.putCachedResult(inputBinding, pdomBinding);
                }
                return pdomBinding;
            }
            this.pdom.putCachedResult(inputBinding, pdomBinding);
        }
        if (this.shouldUpdate(pdomBinding, fromName)) {
            pdomBinding.update(this, fromName.getBinding());
        }
        return pdomBinding;
    }

    /*
     * Unable to fully structure code
     */
    private PDOMBinding createBinding(PDOMNode parent, IBinding binding) throws CoreException {
        pdomBinding = null;
        if (binding instanceof IField) {
            if (parent instanceof IPDOMMemberOwner) {
                pdomBinding = new PDOMCField(this.pdom, (IPDOMMemberOwner)parent, (IField)binding);
            }
        } else if (binding instanceof IVariable) {
            var = (IVariable)binding;
            pdomBinding = new PDOMCVariable(this.pdom, parent, var);
        } else if (binding instanceof IFunction) {
            func = (IFunction)binding;
            pdomBinding = new PDOMCFunction(this.pdom, parent, func);
        } else if (binding instanceof ICompositeType) {
            pdomBinding = new PDOMCStructure(this.pdom, parent, (ICompositeType)binding);
        } else if (binding instanceof IEnumeration) {
            pdomBinding = new PDOMCEnumeration(this.pdom, parent, (IEnumeration)binding);
        } else if (binding instanceof IEnumerator) {
            try {
                enumeration = (IEnumeration)((IEnumerator)binding).getType();
                pdomEnumeration = this.adaptBinding(enumeration);
                if (!(pdomEnumeration instanceof PDOMCEnumeration)) ** GOTO lbl31
                pdomBinding = new PDOMCEnumerator(this.pdom, parent, (IEnumerator)binding, (PDOMCEnumeration)pdomEnumeration);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus((Throwable)e));
            }
        } else if (binding instanceof ITypedef) {
            pdomBinding = new PDOMCTypedef(this.pdom, parent, (ITypedef)binding);
        }
lbl31:
        // 10 sources

        if (pdomBinding != null) {
            pdomBinding.setLocalToFileRec(this.getLocalToFileRec(parent, binding));
            parent.addChild(pdomBinding);
            this.afterAddBinding(pdomBinding);
        }
        return pdomBinding;
    }

    private boolean shouldUpdate(PDOMBinding pdomBinding, IASTName fromName) throws CoreException {
        if (fromName != null) {
            if (fromName.isDefinition()) {
                return true;
            }
            if (fromName.isReference()) {
                return false;
            }
            return !pdomBinding.hasDefinition();
        }
        return false;
    }

    public PDOMBinding addBinding(IASTName name) throws CoreException {
        if (name == null) {
            return null;
        }
        char[] namechars = name.toCharArray();
        if (namechars == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        return this.addBinding(binding, name);
    }

    public int getBindingType(IBinding binding) {
        if (binding instanceof IField) {
            return 9;
        }
        if (binding instanceof IVariable) {
            return 6;
        }
        if (binding instanceof IFunction) {
            return 7;
        }
        if (binding instanceof ICompositeType) {
            return 8;
        }
        if (binding instanceof IEnumeration) {
            return 10;
        }
        if (binding instanceof IEnumerator) {
            return 11;
        }
        if (binding instanceof ITypedef) {
            return 12;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PDOMNode getAdaptedParent(IBinding binding) throws CoreException {
        try {
            IName scopeName;
            IScope scope = binding.getScope();
            if (binding instanceof IIndexBinding) {
                IIndexBinding ib = (IIndexBinding)binding;
                if (ib.isFileLocal()) {
                    return null;
                }
                if (scope == null) {
                    return this;
                }
            }
            if (scope == null) {
                return null;
            }
            if (scope instanceof IIndexScope) {
                if (!(scope instanceof CompositeScope)) return this.adaptBinding(((IIndexScope)scope).getScopeBinding());
                return this.adaptBinding(((CompositeScope)scope).getRawScopeBinding());
            }
            IASTNode scopeNode = ASTInternal.getPhysicalNodeOfScope(scope);
            IBinding scopeBinding = null;
            if (scopeNode instanceof IASTCompoundStatement) {
                return null;
            }
            if (scopeNode instanceof IASTTranslationUnit) {
                IName myOrigScopeName;
                ICompositeType ct;
                IScope ctscope;
                boolean isGlobal = true;
                if (binding instanceof ICompositeType && (ctscope = (ct = (ICompositeType)binding).getCompositeScope()) != null && (myOrigScopeName = ctscope.getScopeName()) instanceof IASTName && myOrigScopeName.toCharArray().length == 0 && (scope = CVisitor.getContainingScope((IASTName)myOrigScopeName)) instanceof ICCompositeTypeScope) {
                    isGlobal = false;
                }
                if (isGlobal) {
                    return this;
                }
            }
            if (!((scopeName = scope.getScopeName()) instanceof IASTName)) return null;
            scopeBinding = ((IASTName)scopeName).resolveBinding();
            if (scopeBinding == null) return null;
            if (scopeBinding == binding) return null;
            return this.adaptBinding(scopeBinding);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    public final PDOMBinding adaptBinding(IBinding inputBinding) throws CoreException {
        return this.adaptBinding(null, inputBinding);
    }

    private final PDOMBinding adaptBinding(PDOMNode parent, IBinding inputBinding) throws CoreException {
        if (this.cannotAdapt(inputBinding)) {
            return null;
        }
        PDOMBinding result = this.attemptFastAdaptBinding(inputBinding);
        if (result != null) {
            return result;
        }
        IBinding binding = PDOMASTAdapter.getAdapterForAnonymousASTBinding(inputBinding);
        if (binding == null) {
            return null;
        }
        result = this.doAdaptBinding(parent, binding);
        if (result != null) {
            this.pdom.putCachedResult(inputBinding, result);
        }
        return result;
    }

    private final PDOMBinding doAdaptBinding(PDOMNode parent, IBinding binding) throws CoreException {
        if (parent == null) {
            parent = this.getAdaptedParent(binding);
        }
        if (parent == this) {
            int localToFileRec = this.getLocalToFileRec(null, binding);
            return FindBinding.findBinding(this.getIndex(), this.getPDOM(), binding.getNameCharArray(), new int[]{this.getBindingType(binding)}, localToFileRec);
        }
        if (parent instanceof IPDOMMemberOwner) {
            int localToFileRec = this.getLocalToFileRec(parent, binding);
            return FindBinding.findBinding(parent, this.getPDOM(), binding.getNameCharArray(), new int[]{this.getBindingType(binding)}, localToFileRec);
        }
        return null;
    }

    public PDOMNode getNode(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 6: {
                return new PDOMCVariable(this.pdom, record);
            }
            case 7: {
                return new PDOMCFunction(this.pdom, record);
            }
            case 8: {
                return new PDOMCStructure(this.pdom, record);
            }
            case 9: {
                return new PDOMCField(this.pdom, record);
            }
            case 10: {
                return new PDOMCEnumeration(this.pdom, record);
            }
            case 11: {
                return new PDOMCEnumerator(this.pdom, record);
            }
            case 12: {
                return new PDOMCTypedef(this.pdom, record);
            }
            case 13: {
                return new PDOMCParameter(this.pdom, record);
            }
            case 14: {
                return new PDOMCBasicType(this.pdom, record);
            }
            case 15: {
                return new PDOMCFunctionType(this.pdom, record);
            }
        }
        return super.getNode(record);
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        if (type instanceof IProblemBinding) {
            return null;
        }
        if (type instanceof ICBasicType) {
            return new PDOMCBasicType(this.pdom, parent, (ICBasicType)type);
        }
        if (type instanceof IFunctionType) {
            return new PDOMCFunctionType(this.pdom, parent, (IFunctionType)type);
        }
        if (type instanceof IBinding) {
            return this.addBinding((IBinding)((Object)type), null);
        }
        return super.addType(parent, type);
    }

    public IBTreeComparator getIndexComparator() {
        return new FindBinding.DefaultBindingBTreeComparator(this.getPDOM());
    }
}

