/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.CPPReferenceTypeClone;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPReferenceType
extends PDOMNode
implements ICPPReferenceType,
ITypeContainer,
IIndexType {
    private static final int TYPE = 8;
    protected static final int RECORD_SIZE = 12;

    public PDOMCPPReferenceType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPReferenceType(PDOM pdom, PDOMNode parent, ICPPReferenceType type) throws CoreException {
        super(pdom, parent);
        Database db = pdom.getDB();
        try {
            int typeRec = 0;
            if (type != null) {
                IType targetType = type.getType();
                PDOMNode targetTypeNode = this.getLinkageImpl().addType(this, targetType);
                if (targetTypeNode != null) {
                    typeRec = targetTypeNode.getRecord();
                }
            }
            db.putInt(this.record + 8, typeRec);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    protected int getRecordSize() {
        return 12;
    }

    public int getNodeType() {
        return 20;
    }

    public IType getType() {
        try {
            PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 8));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPReferenceType)) {
            return false;
        }
        ICPPReferenceType rhs = (ICPPReferenceType)type;
        try {
            IType type1 = this.getType();
            if (type1 != null) {
                return type1.isSameType(rhs.getType());
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    public void setType(IType type) {
        throw new PDOMNotImplementedError();
    }

    public Object clone() {
        return new CPPReferenceTypeClone(this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        super.delete(linkage);
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

