/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTFieldReference
extends CPPASTNode
implements ICPPASTFieldReference,
IASTAmbiguityParent,
IASTCompletionContext {
    private boolean isTemplate;
    private IASTExpression owner;
    private IASTName name;
    private boolean isDeref;

    public CPPASTFieldReference() {
    }

    public CPPASTFieldReference(IASTName name, IASTExpression owner, boolean isDeref, boolean isTemplate) {
        this.setFieldName(name);
        this.setFieldOwner(owner);
        this.isTemplate = isTemplate;
        this.isDeref = isDeref;
    }

    public CPPASTFieldReference(IASTName name, IASTExpression owner) {
        this(name, owner, false, false);
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(boolean value) {
        this.isTemplate = value;
    }

    public IASTExpression getFieldOwner() {
        return this.owner;
    }

    public void setFieldOwner(IASTExpression expression) {
        this.owner = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FIELD_OWNER);
        }
    }

    public IASTName getFieldName() {
        return this.name;
    }

    public void setFieldName(IASTName name) {
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(FIELD_NAME);
        }
    }

    public boolean isPointerDereference() {
        return this.isDeref;
    }

    public void setIsPointerDereference(boolean value) {
        this.isDeref = value;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.owner != null && !this.owner.accept(action)) {
            return false;
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.owner) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.owner = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        return CPPVisitor.getExpressionType(this);
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        int i = 0;
        while (i < bindings.length) {
            ICPPMethod method;
            if (!(bindings[i] instanceof ICPPMethod) || !(method = (ICPPMethod)bindings[i]).isImplicit()) {
                filtered.add(bindings[i]);
            }
            ++i;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }
}

