/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPFunctionScope
extends CPPScope
implements ICPPFunctionScope {
    private CharArrayObjectMap labels = CharArrayObjectMap.EMPTY_MAP;

    public CPPFunctionScope(IASTFunctionDeclarator physicalNode) {
        super(physicalNode);
    }

    public void addBinding(IBinding binding) {
        if (!(binding instanceof ILabel)) {
            return;
        }
        if (this.labels == CharArrayObjectMap.EMPTY_MAP) {
            this.labels = new CharArrayObjectMap(2);
        }
        this.labels.put(binding.getNameCharArray(), binding);
    }

    public IBinding getBinding(IASTName name) {
        return (IBinding)this.labels.get(name.toCharArray());
    }

    public IBinding[] find(String name) throws DOMException {
        char[] n = name.toCharArray();
        ArrayList<IBinding> bindings = new ArrayList<IBinding>();
        int i = 0;
        while (i < this.labels.size()) {
            char[] key = this.labels.keyAt(i);
            if (CharArrayUtils.equals(key, n)) {
                bindings.add((IBinding)this.labels.get(key));
            }
            ++i;
        }
        IBinding[] additional = super.find(name);
        int i2 = 0;
        while (i2 < additional.length) {
            bindings.add(additional[i2]);
            ++i2;
        }
        return bindings.toArray(new IBinding[bindings.size()]);
    }

    public IScope getParent() throws DOMException {
        IASTFunctionDeclarator fdtor = (IASTFunctionDeclarator)this.getPhysicalNode();
        IASTName name = fdtor.getName();
        if (name instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qual = (ICPPASTQualifiedName)name;
            IASTName[] ns = qual.getNames();
            if (ns.length > 1) {
                IBinding binding = ns[ns.length - 2].resolveBinding();
                if (binding == null) {
                    return null;
                }
                if (binding instanceof ICPPClassType) {
                    return ((ICPPClassType)binding).getCompositeScope();
                }
                if (binding instanceof ICPPNamespace) {
                    return ((ICPPNamespace)binding).getNamespaceScope();
                }
                return binding.getScope();
            }
            if (qual.isFullyQualified()) {
                return qual.getTranslationUnit().getScope();
            }
        }
        return CPPVisitor.getContainingScope(name);
    }

    public IScope getBodyScope() {
        IASTStatement body;
        IASTFunctionDeclarator fnDtor = (IASTFunctionDeclarator)this.getPhysicalNode();
        IASTNode parent = fnDtor.getParent();
        if (parent instanceof IASTFunctionDefinition && (body = ((IASTFunctionDefinition)parent).getBody()) instanceof IASTCompoundStatement) {
            return ((IASTCompoundStatement)body).getScope();
        }
        return null;
    }

    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTFunctionDeclarator) {
            return ((ICPPASTFunctionDeclarator)node).getName();
        }
        return null;
    }

    public void flushCache() {
        this.labels.clear();
        super.flushCache();
    }
}

