/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.remotesimulator.ui;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.cell.environment.remotesimulator.core.ConfigFactory;
import org.eclipse.ptp.cell.environment.remotesimulator.core.TargetControl;
import org.eclipse.ptp.cell.environment.remotesimulator.ui.Messages;
import org.eclipse.ptp.cell.environment.remotesimulator.ui.SimulatorConfigDialog;
import org.eclipse.ptp.remotetools.environment.wizard.AbstractEnvironmentDialogPage;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrame;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrameMold;
import org.eclipse.ptp.utils.ui.swt.ComboGroup;
import org.eclipse.ptp.utils.ui.swt.ComboGroupItem;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConfigurationPage
extends AbstractEnvironmentDialogPage {
    private Map attributesMap;
    private ControlAttributes attributes;
    private boolean hasWarning = false;
    private boolean hasError = false;
    private String targetName;
    private TextGroup targetNameText;
    private Button optionAutomatic;
    private Button optionCustom;
    private Button openCustomWindow;
    private AuthenticationFrame remoteConnGroup;
    private ModifyListener textModifyListener;
    private TextGroup systemWorkspaceGroup;

    public ConfigurationPage(String targetName, Map attributesMap) {
        super(targetName);
        this.attributesMap = attributesMap;
        this.targetName = targetName;
        this.attributes = new ControlAttributes(this.attributesMap);
    }

    public ConfigurationPage() {
        super(Messages.ConfigurationPage_RemoteCellSimulatorLabel);
        this.attributesMap = ConfigFactory.createDefaultConfig();
        this.targetName = Messages.ConfigurationPage_RemoteCellSimulatorLabel;
        this.attributes = new ControlAttributes(this.attributesMap);
    }

    public void createControl(Composite parent) {
        this.setDescription(Messages.ConfigurationPage_RemoteCellSimulatorConnectionProperties);
        this.setTitle(Messages.ConfigurationPage_RemoteCellSimulatorLabel);
        this.setErrorMessage(null);
        GridLayout topLayout = new GridLayout();
        Composite topControl = new Composite(parent, 0);
        this.setControl((Control)topControl);
        topControl.setLayout((Layout)topLayout);
        this.textModifyListener = new TextModifyListener();
        TextMold tmold = new TextMold(TextMold.GRID_DATA_SPAN | TextMold.GRID_DATA_ALIGNMENT_FILL, Messages.ConfigurationPage_TargetNameLabel);
        tmold.setValue(this.targetName);
        this.targetNameText = new TextGroup(topControl, tmold);
        this.targetNameText.getText().addModifyListener(this.textModifyListener);
        this.createRemoteConnectionGroup(topControl);
        this.fillRemoteConnectionGroup();
        this.registerRemoteConnectionGroup();
        this.createSimulatorConfigurationGroup(topControl);
        this.fillSimulatorConfigurationOption();
        this.registerSimulatorConfigurationGroup();
        this.generateSystemWorkspaceConfigurationGroup(topControl);
        this.validateFields();
    }

    private void generateSystemWorkspaceConfigurationGroup(Composite topControl) {
        Frame frame = new Frame(topControl, Messages.ConfigurationPage_CellApplicationLaunch);
        TextMold mold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_BaseDir);
        this.systemWorkspaceGroup = new TextGroup(frame.getTopUserReservedComposite(), mold);
        this.systemWorkspaceGroup.setString(this.attributes.getString("system-workspace-dir"));
        this.systemWorkspaceGroup.addModifyListener((ModifyListener)new TextModifyListener());
    }

    private void registerSimulatorConfigurationGroup() {
        this.openCustomWindow.addSelectionListener((SelectionListener)new RemoteSimulatorPushButtonListener());
        RemoteSimulatorOptionButtonListener rsimoptlisten = new RemoteSimulatorOptionButtonListener();
        this.optionAutomatic.addSelectionListener((SelectionListener)rsimoptlisten);
    }

    private void registerRemoteConnectionGroup() {
        this.remoteConnGroup.addModifyListener(this.textModifyListener);
    }

    private void fillSimulatorConfigurationOption() {
        boolean boolValue = this.attributes.getBooleanAttribute("simulator-is-automatic-config", ConfigFactory.DEFAULT_SIMULATOR_IS_AUTOMATIC_CONFIG);
        this.remoteSimulatorOptionButtonsAction(boolValue);
    }

    private void fillRemoteConnectionGroup() {
        this.fillTextGroup(this.remoteConnGroup.getHostAddrTextGroup(), "remote-connection-address", ConfigFactory.DEFAULT_REMOTE_CONNECTION_ADDRESS);
        this.fillTextGroup(this.remoteConnGroup.getHostPortTextGroup(), "remote-connection-port", Integer.toString(ConfigFactory.DEFAULT_REMOTE_CONNECTION_PORT));
        this.fillTextGroup(this.remoteConnGroup.getUsernameTextGroup(), "remote-login-username", ConfigFactory.DEFAULT_REMOTE_LOGIN_USERNAME);
        this.fillTextGroup(this.remoteConnGroup.getPasswordTextGroup(), "remote-login-password", ConfigFactory.DEFAULT_REMOTE_LOGIN_PASSWORD);
        this.fillTextGroup((TextGroup)this.remoteConnGroup.getPublicKeyPathGroup(), "remote-key-path", ConfigFactory.DEFAULT_REMOTE_KEY_PATH);
        this.fillTextGroup(this.remoteConnGroup.getPassphraseTextGroup(), "remote-key-passphrase", ConfigFactory.DEFAULT_REMOTE_KEY_PASSPHRASE);
        this.remoteConnGroup.setPasswordBased(this.attributes.getBooleanAttribute("remote-is-password-auth", ConfigFactory.DEFAULT_REMOTE_IS_PASSWORD_AUTH));
        this.fillTextGroup(this.remoteConnGroup.getTimeoutTextGroup(), "remote-timeout", Integer.toString(ConfigFactory.DEFAULT_REMOTE_CONNECTION_TIMEOUT));
        Map cipherMap = TargetControl.getCipherTypesMap();
        Set cKeySet = cipherMap.keySet();
        ComboGroup cipherGroup = this.remoteConnGroup.getCipherTypeGroup();
        for (String key : cKeySet) {
            String value = (String)cipherMap.get(key);
            cipherGroup.add(new ComboGroupItem(key, value));
        }
        cipherGroup.selectIndexUsingID(this.attributes.getString("remote-cipher-type"));
    }

    private void fillTextGroup(TextGroup tgroup, String key, String defaultValue) {
        Text tbox = tgroup.getText();
        tbox.setText(this.attributes.getStringAttribute(key, defaultValue));
    }

    private void createSimulatorConfigurationGroup(Composite topControl) {
        FrameMold mold = new FrameMold(Messages.ConfigurationPage_RemoteHostToSimulatorConnection, 2, false);
        Frame fdesc = new Frame(topControl, mold);
        this.optionAutomatic = new Button(fdesc.getTopUserReservedComposite(), 16);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.optionAutomatic.setLayoutData((Object)gdata);
        this.optionAutomatic.setText(Messages.ConfigurationPage_Automatic);
        this.optionCustom = new Button(fdesc.getTopUserReservedComposite(), 16);
        gdata = new GridData();
        this.optionCustom.setLayoutData((Object)gdata);
        this.optionCustom.setText(Messages.ConfigurationPage_Custom);
        this.openCustomWindow = new Button(fdesc.getTopUserReservedComposite(), 8);
        this.openCustomWindow.setLayoutData((Object)new GridData());
        this.openCustomWindow.setText(Messages.ConfigurationPage_Set);
    }

    private void remoteSimulatorOptionButtonsAction(boolean isAutoConf) {
        this.optionAutomatic.setSelection(isAutoConf);
        this.optionCustom.setSelection(!isAutoConf);
        this.openCustomWindow.setEnabled(!isAutoConf);
        this.attributes.setBooleanAttribute("simulator-is-automatic-config", isAutoConf);
    }

    private void createSimulatorConfigurationWindow() {
        SimulatorConfigDialog dialog = new SimulatorConfigDialog(this.getShell(), this.attributes);
        dialog.open();
        this.attributes = dialog.getModifiedAttributes();
    }

    public Map getAttributes() {
        return this.attributesMap;
    }

    public boolean isValid() {
        this.validateFields();
        return !this.hasError;
    }

    public String getName() {
        return this.targetName;
    }

    public void validateFields() {
        this.hasWarning = false;
        this.hasError = false;
        try {
            this.remoteConnGroup.validateFields();
        }
        catch (CoreException e) {
            this.hasError = true;
            this.setErrorMessage(e.getMessage());
        }
        ConfigFactory factory = new ConfigFactory(this.attributes);
        factory.checkTargetConfig();
    }

    private void createRemoteConnectionGroup(Composite parent) {
        AuthenticationFrameMold amold = new AuthenticationFrameMold(Messages.ConfigurationPage_RemoteHostInfo);
        this.remoteConnGroup = new AuthenticationFrame(parent, amold);
        this.remoteConnGroup.setLayoutData((Object)new GridData(1808));
    }

    class RemoteSimulatorOptionButtonListener
    extends SelectionAdapter {
        RemoteSimulatorOptionButtonListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            boolean auto = ConfigurationPage.this.optionAutomatic.getSelection();
            ConfigurationPage.this.remoteSimulatorOptionButtonsAction(auto);
        }
    }

    class RemoteSimulatorPushButtonListener
    extends SelectionAdapter {
        RemoteSimulatorPushButtonListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            ConfigurationPage.this.createSimulatorConfigurationWindow();
        }
    }

    class TextModifyListener
    implements ModifyListener {
        TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget instanceof Text) {
                String textValue = ((Text)e.widget).getText();
                if (e.widget == ConfigurationPage.this.targetNameText.getText()) {
                    ConfigurationPage.this.targetName = textValue;
                }
                if (e.widget == ConfigurationPage.this.remoteConnGroup.getHostAddrTextGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-connection-address", textValue);
                } else if (e.widget == ConfigurationPage.this.remoteConnGroup.getHostPortTextGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-connection-port", textValue);
                } else if (e.widget == ConfigurationPage.this.remoteConnGroup.getUsernameTextGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-login-username", textValue);
                } else if (e.widget == ConfigurationPage.this.remoteConnGroup.getPasswordTextGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-login-password", textValue);
                } else if (e.widget == ConfigurationPage.this.remoteConnGroup.getPublicKeyPathGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-key-path", textValue);
                } else if (e.widget == ConfigurationPage.this.remoteConnGroup.getPassphraseTextGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-key-passphrase", textValue);
                } else if (e.widget == ConfigurationPage.this.remoteConnGroup.getTimeoutTextGroup().getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("remote-timeout", textValue);
                } else if (e.widget == ConfigurationPage.this.systemWorkspaceGroup.getText()) {
                    ConfigurationPage.this.attributes.setStringAttribute("system-workspace-dir", textValue);
                }
            } else if (e.widget instanceof Button) {
                boolean passwdBased = e.widget == ConfigurationPage.this.remoteConnGroup.getAuthKindSelectionButtons()[0];
                ConfigurationPage.this.remoteConnGroup.setPasswordBased(passwdBased);
                ConfigurationPage.this.attributes.setBooleanAttribute("remote-is-password-auth", passwdBased);
            } else if (e.widget instanceof Combo) {
                ConfigurationPage.this.attributes.setAttribute("remote-cipher-type", ConfigurationPage.this.remoteConnGroup.getSelectedCipherType().getId());
            }
            ConfigurationPage.this.getContainer().updateButtons();
        }
    }
}

