/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.make.internal.core.scannerconfig;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.make.internal.core.scannerconfig2.GCCSpecsRunSIProvider;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.cell.make.core.debug.Debug;

public class CellSpecsRunSIProvider
extends GCCSpecsRunSIProvider {
    protected static final String EMPTY_STRING = "";

    protected boolean initialize() {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_XL_PROVIDER);
        boolean rc = super.initialize();
        if (rc) {
            try {
                this.fCompileCommand = new Path(this.checkFileExistenceOnPath(this.fCompileCommand.toString()));
                Debug.POLICY.trace(Debug.DEBUG_XL_PROVIDER, "Command line: {0}", new Object[]{this.fCompileCommand});
            }
            catch (Exception e) {
                Debug.POLICY.error(Debug.DEBUG_XL_PROVIDER, (Throwable)e);
                e.printStackTrace();
                return false;
            }
        }
        Debug.POLICY.exit(Debug.DEBUG_XL_PROVIDER);
        return rc;
    }

    private String checkFileExistenceOnPath(String fileName) {
        String[] paths;
        IManagedBuildInfo managedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.resource.getProject());
        String currentProfileId = this.buildInfo.getSelectedProfileId();
        currentProfileId = currentProfileId.substring(currentProfileId.lastIndexOf(46) + 1, currentProfileId.length());
        IConfiguration activeConfiguration = managedBuildInfo.getDefaultConfiguration();
        String[] stringArray = paths = this.getEnvironmentPath(activeConfiguration);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File pathEntryFile = new File(path);
            File compilerFile = new File(pathEntryFile, fileName);
            if (compilerFile.exists()) {
                return compilerFile.getAbsolutePath();
            }
            ++n2;
        }
        return EMPTY_STRING;
    }

    private String[] getEnvironmentPath(IConfiguration activeConfiguration) {
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)activeConfiguration);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable path = mngr.getVariable("PATH", cfgDes, true);
        String[] pathValues = path.getValue().split(path.getDelimiter());
        return pathValues;
    }
}

