/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IPRegisterManager;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPPersistableRegisterGroup;
import org.eclipse.ptp.debug.core.model.IPRegisterDescriptor;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegisterDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIRegisterGroup;
import org.eclipse.ptp.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PRegisterDescriptor;
import org.eclipse.ptp.debug.internal.core.model.PRegisterGroup;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PRegisterManager
implements IAdaptable,
IPRegisterManager {
    private static final String ELEMENT_REGISTER_GROUP_LIST = "registerGroups";
    private static final String ELEMENT_REGISTER_GROUP = "group";
    private static final String ATTR_REGISTER_GROUP_MEMENTO = "memento";
    private final IPSession session;
    protected final Map<BitList, PRegisterSet> fRegisterSetMap = new HashMap<BitList, PRegisterSet>();

    public PRegisterManager(IPSession session) {
        this.session = session;
    }

    public void addRegisterGroup(final BitList qTasks, final String name, final IPRegisterDescriptor[] descriptors) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PRegisterManager.this.getRegisterSet(qTasks).addRegisterGroup(name, descriptors);
            }
        });
    }

    public void dispose(IProgressMonitor monitor) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map<BitList, PRegisterSet> map = PRegisterManager.this.fRegisterSetMap;
                synchronized (map) {
                    Iterator<PRegisterSet> it = PRegisterManager.this.fRegisterSetMap.values().iterator();
                    while (it.hasNext()) {
                        it.next().dispose();
                    }
                    PRegisterManager.this.fRegisterSetMap.clear();
                }
            }
        });
    }

    public IPRegisterDescriptor findDescriptor(BitList qTasks, String groupName, String name) {
        return this.getRegisterSet(qTasks).findDescriptor(groupName, name);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPSession.class)) {
            return this.getSession();
        }
        if (adapter.equals(PRegisterManager.class)) {
            return this;
        }
        return null;
    }

    public IPRegisterDescriptor[] getAllRegisterDescriptors(BitList qTasks) throws DebugException {
        return this.getRegisterSet(qTasks).getAllRegisterDescriptors();
    }

    public IPStackFrame getCurrentFrame(BitList qTasks) {
        return this.getRegisterSet(qTasks).getCurrentFrame();
    }

    public IRegisterGroup[] getRegisterGroups(BitList qTasks, PStackFrame frame) throws DebugException {
        return this.getRegisterSet(qTasks).getRegisterGroups(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PRegisterSet getRegisterSet(BitList qTasks) {
        Map<BitList, PRegisterSet> map = this.fRegisterSetMap;
        synchronized (map) {
            PRegisterSet set = this.fRegisterSetMap.get(qTasks);
            if (set == null) {
                set = new PRegisterSet(qTasks, null);
                this.fRegisterSetMap.put(qTasks, set);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(BitList qTasks, PDebugTarget debugTarget) {
        Map<BitList, PRegisterSet> map = this.fRegisterSetMap;
        synchronized (map) {
            PRegisterSet set = new PRegisterSet(qTasks, debugTarget);
            this.fRegisterSetMap.put(qTasks, set);
            set.initialize();
        }
    }

    public void modifyRegisterGroup(final BitList qTasks, final IPPersistableRegisterGroup group, final IPRegisterDescriptor[] descriptors) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PRegisterManager.this.getRegisterSet(qTasks).modifyRegisterGroup(group, descriptors);
            }
        });
    }

    public void removeAllRegisterGroups(final BitList qTasks) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PRegisterManager.this.getRegisterSet(qTasks).removeAllRegisterGroups();
            }
        });
    }

    public void removeRegisterGroups(final BitList qTasks, final IRegisterGroup[] groups) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PRegisterManager.this.getRegisterSet(qTasks).removeRegisterGroups(groups);
            }
        });
    }

    public void restoreDefaults(final BitList qTasks) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                PRegisterManager.this.getRegisterSet(qTasks).restoreDefaults();
            }
        });
    }

    public void save(BitList qTasks) {
        try {
            String memto = this.getRegisterSet(qTasks).getMemento();
            ILaunchConfiguration config = this.session.getLaunch().getLaunchConfiguration();
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.ptp.launch.DEBUGGER_REGISTER_GROUPS", memto);
            wc.doSave();
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    public void targetSuspended(BitList qTasks) {
        this.getRegisterSet(qTasks).targetSuspended();
    }

    protected IPSession getSession() {
        return this.session;
    }

    private class PRegisterSet {
        private final List<IRegisterGroup> fRegisterGroups = Collections.synchronizedList(new ArrayList(20));
        private IPRegisterDescriptor[] fRegisterDescriptors;
        private boolean fUseDefaultRegisterGroups = true;
        private IPStackFrame fCurrentFrame;
        private IPDebugTarget debugTarget = null;
        private final BitList rTasks;

        public PRegisterSet(BitList rTasks, PDebugTarget debugTarget) {
            this.rTasks = rTasks;
            this.debugTarget = debugTarget;
        }

        public void abort(String message, Throwable exception) throws CoreException {
            Status status = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, exception);
            throw new CoreException((IStatus)status);
        }

        public void addRegisterGroup(String name, IPRegisterDescriptor[] descriptors) {
            this.fRegisterGroups.add(new PRegisterGroup(PRegisterManager.this.session, this.rTasks, name, descriptors));
            this.setUseDefaultRegisterGroups(false);
            this.getDebugTarget().fireChangeEvent(512);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            List<IRegisterGroup> list = this.fRegisterGroups;
            synchronized (list) {
                Iterator<IRegisterGroup> it = this.fRegisterGroups.iterator();
                while (it.hasNext()) {
                    ((PRegisterGroup)it.next()).dispose();
                }
                this.fRegisterGroups.clear();
            }
        }

        public void doAddRegisterGroup(IRegisterGroup group) {
            this.fRegisterGroups.add(group);
        }

        public IPRegisterDescriptor findDescriptor(String groupName, String name) {
            int i = 0;
            while (i < this.fRegisterDescriptors.length) {
                IPRegisterDescriptor d = this.fRegisterDescriptors[i];
                if (groupName.equals(d.getGroupName()) && name.equals(d.getName())) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        public IPRegisterDescriptor[] getAllRegisterDescriptors() throws DebugException {
            return this.fRegisterDescriptors;
        }

        public IPStackFrame getCurrentFrame() {
            return this.fCurrentFrame;
        }

        public IPDebugTarget getDebugTarget() {
            if (this.debugTarget == null) {
                this.debugTarget = PRegisterManager.this.session.findDebugTarget(this.rTasks);
            }
            return this.debugTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getMemento() throws CoreException {
            List<IRegisterGroup> list = this.fRegisterGroups;
            synchronized (list) {
                block5: {
                    if (!this.useDefaultRegisterGroups() && this.fRegisterGroups != null) break block5;
                    return "";
                }
                Document document = DebugPlugin.newDocument();
                Element element = document.createElement(PRegisterManager.ELEMENT_REGISTER_GROUP_LIST);
                for (PRegisterGroup pRegisterGroup : this.fRegisterGroups) {
                    Element child = document.createElement(PRegisterManager.ELEMENT_REGISTER_GROUP);
                    child.setAttribute(PRegisterManager.ATTR_REGISTER_GROUP_MEMENTO, pRegisterGroup.getMemento());
                    element.appendChild(child);
                }
                document.appendChild(element);
                return DebugPlugin.serializeDocument((Document)document);
            }
        }

        public IRegisterGroup[] getRegisterGroups(PStackFrame frame) throws DebugException {
            IRegisterGroup[] groups = this.fRegisterGroups.toArray(new IRegisterGroup[0]);
            if (this.getCurrentFrame() != frame) {
                int i = 0;
                while (i < groups.length) {
                    ((PRegisterGroup)groups[i]).resetRegisterValues();
                    ++i;
                }
                this.setCurrentFrame(frame);
            }
            return groups;
        }

        public void initialize() {
            IPDIRegisterGroup[] groups = new IPDIRegisterGroup[]{};
            try {
                groups = this.getDebugTarget().getPDITarget().getRegisterGroups();
            }
            catch (PDIException e) {
                PTPDebugCorePlugin.log(e);
            }
            ArrayList<PRegisterDescriptor> list = new ArrayList<PRegisterDescriptor>();
            int i = 0;
            while (i < groups.length) {
                try {
                    IPDIRegisterDescriptor[] pdiDescriptors = groups[i].getRegisterDescriptors();
                    int j = 0;
                    while (j < pdiDescriptors.length) {
                        list.add(new PRegisterDescriptor(groups[i], pdiDescriptors[j]));
                        ++j;
                    }
                }
                catch (PDIException e) {
                    PTPDebugCorePlugin.log(e);
                }
                ++i;
            }
            this.fRegisterDescriptors = list.toArray(new IPRegisterDescriptor[0]);
            this.createRegisterGroups();
        }

        public void initializeDefaults() {
            this.setUseDefaultRegisterGroups(true);
            String current = null;
            int startIndex = 0;
            int i = 0;
            while (i < this.fRegisterDescriptors.length) {
                PRegisterDescriptor d = (PRegisterDescriptor)this.fRegisterDescriptors[i];
                if (current != null && d.getGroupName().compareTo(current) != 0) {
                    IPRegisterDescriptor[] descriptors = new IPRegisterDescriptor[i - startIndex];
                    System.arraycopy(this.fRegisterDescriptors, startIndex, descriptors, 0, descriptors.length);
                    this.fRegisterGroups.add(new PRegisterGroup(PRegisterManager.this.session, this.rTasks, current, descriptors));
                    startIndex = i;
                }
                current = d.getGroupName();
                ++i;
            }
            if (startIndex < this.fRegisterDescriptors.length) {
                IPRegisterDescriptor[] descriptors = new IPRegisterDescriptor[this.fRegisterDescriptors.length - startIndex];
                System.arraycopy(this.fRegisterDescriptors, startIndex, descriptors, 0, descriptors.length);
                this.fRegisterGroups.add(new PRegisterGroup(PRegisterManager.this.session, this.rTasks, current, descriptors));
            }
        }

        public void modifyRegisterGroup(IPPersistableRegisterGroup group, IPRegisterDescriptor[] descriptors) {
            group.setRegisterDescriptors(descriptors);
            ((PRegisterGroup)group).fireChangeEvent(512);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllRegisterGroups() {
            List<IRegisterGroup> list = this.fRegisterGroups;
            synchronized (list) {
                Iterator<IRegisterGroup> it = this.fRegisterGroups.iterator();
                while (it.hasNext()) {
                    ((PRegisterGroup)it.next()).dispose();
                }
                this.fRegisterGroups.clear();
            }
            this.setUseDefaultRegisterGroups(false);
            this.getDebugTarget().fireChangeEvent(512);
        }

        public void removeRegisterGroups(IRegisterGroup[] groups) {
            int i = 0;
            while (i < groups.length) {
                ((PRegisterGroup)groups[i]).dispose();
                ++i;
            }
            this.fRegisterGroups.removeAll(Arrays.asList(groups));
            this.setUseDefaultRegisterGroups(false);
            this.getDebugTarget().fireChangeEvent(512);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreDefaults() {
            List<IRegisterGroup> list = this.fRegisterGroups;
            synchronized (list) {
                Iterator<IRegisterGroup> it = this.fRegisterGroups.iterator();
                while (it.hasNext()) {
                    ((PRegisterGroup)it.next()).dispose();
                }
                this.fRegisterGroups.clear();
                this.initializeDefaults();
            }
            this.getDebugTarget().fireChangeEvent(512);
        }

        public void setCurrentFrame(PStackFrame currentFrame) {
            this.fCurrentFrame = currentFrame;
        }

        public void setUseDefaultRegisterGroups(boolean useDefaultRegisterGroups) {
            this.fUseDefaultRegisterGroups = useDefaultRegisterGroups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void targetSuspended() {
            List<IRegisterGroup> list = this.fRegisterGroups;
            synchronized (list) {
                Iterator<IRegisterGroup> it = this.fRegisterGroups.iterator();
                while (it.hasNext()) {
                    ((PRegisterGroup)it.next()).targetSuspended();
                }
            }
        }

        public boolean useDefaultRegisterGroups() {
            return this.fUseDefaultRegisterGroups;
        }

        private void createRegisterGroups() {
            ILaunchConfiguration config = PRegisterManager.this.session.getLaunch().getLaunchConfiguration();
            try {
                String memento = config.getAttribute("org.eclipse.ptp.launch.DEBUGGER_REGISTER_GROUPS", "");
                if (memento != null && memento.length() > 0) {
                    this.initializeFromMemento(memento);
                    return;
                }
            }
            catch (CoreException coreException) {}
            this.initializeDefaults();
        }

        private void initializeFromMemento(String memento) throws CoreException {
            Element element;
            Element node = DebugPlugin.parseDocument((String)memento);
            if (node.getNodeType() != 1) {
                this.abort(InternalDebugCoreMessages.getString("PRegisterManager.0"), null);
            }
            if (!PRegisterManager.ELEMENT_REGISTER_GROUP_LIST.equals((element = node).getNodeName())) {
                this.abort(InternalDebugCoreMessages.getString("PRegisterManager.1"), null);
            }
            Node childNode = element.getFirstChild();
            while (childNode != null) {
                Element child;
                if (childNode.getNodeType() == 1 && PRegisterManager.ELEMENT_REGISTER_GROUP.equals((child = (Element)childNode).getNodeName())) {
                    String groupMemento = child.getAttribute(PRegisterManager.ATTR_REGISTER_GROUP_MEMENTO);
                    PRegisterGroup group = new PRegisterGroup(PRegisterManager.this.session, this.rTasks);
                    try {
                        group.initializeFromMemento(groupMemento);
                        this.doAddRegisterGroup(group);
                    }
                    catch (CoreException coreException) {}
                }
                childNode = childNode.getNextSibling();
            }
            this.setUseDefaultRegisterGroups(false);
        }
    }
}

