/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITargetManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class TargetManager
extends AbstractPDIManager
implements IPDITargetManager {
    private Map<BitList, IPDITarget> targetMap = new HashMap<BitList, IPDITarget>();

    public TargetManager(IPDISession session) {
        super(session, true);
    }

    public IPDITarget addTarget(BitList qTasks) {
        if (this.getTarget(qTasks) == null) {
            IPDITarget target = this.session.getModelFactory().newTarget(this.session, qTasks);
            this.targetMap.put(qTasks, target);
            return target;
        }
        return null;
    }

    public void cleanup() {
        this.targetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPDITarget getTarget(BitList qTasks) {
        Map<BitList, IPDITarget> map = this.targetMap;
        synchronized (map) {
            return this.targetMap.get(qTasks);
        }
    }

    public IPDITarget[] getTargets() {
        return this.targetMap.values().toArray(new IPDITarget[0]);
    }

    public boolean removeTarget(BitList qTasks) {
        return this.targetMap.remove(qTasks) != null;
    }

    public void shutdown() {
        this.targetMap.clear();
    }

    public void update(BitList qTasks) throws PDIException {
    }
}

