/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.examples.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.cell.examples.ui.debug.Debug;
import org.eclipse.ptp.cell.examples.ui.internal.ExampleMessages;
import org.eclipse.ptp.cell.examples.ui.internal.ExampleProjectWizardRegistry;
import org.eclipse.ptp.cell.examples.ui.internal.ExampleUIPlugin;
import org.eclipse.ptp.cell.examples.ui.internal.ProjectWizardDefinition;
import org.eclipse.ptp.cell.examples.ui.internal.wizards.ExampleProjectCreationOperation;
import org.eclipse.ptp.cell.examples.ui.internal.wizards.ExampleProjectCreationWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ExampleProjectCreationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected final String WIZARD_ID = "id";
    protected final String WIZARD_NAME = "name";
    private final String WEB_BROWSER_ID = "org.eclipse.ui.browser.editor";
    protected IConfigurationElement wizardConfigElement;
    protected List projectWizardDefinitionList;
    public final String EMPTY_STRING = "";

    public ExampleProjectCreationWizard() {
        this.setDialogSettings(ExampleUIPlugin.getDefault().getDialogSettings());
    }

    public void addPages() {
        ListIterator i = this.projectWizardDefinitionList.listIterator();
        while (i.hasNext()) {
            this.addPage((IWizardPage)new ExampleProjectCreationWizardPage((ProjectWizardDefinition)i.next()));
        }
    }

    public boolean performFinish() {
        ExampleProjectCreationOperation runnable = new ExampleProjectCreationOperation(this);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ExampleMessages.operationErrorTitle, (String)e.getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.wizardConfigElement);
        IResource fileToOpen = runnable.getFileToOpen();
        if (fileToOpen != null) {
            this.openFile(fileToOpen);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.wizardConfigElement.getAttribute("name"));
        this.setNeedsProgressMonitor(true);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.wizardConfigElement = config;
        this.projectWizardDefinitionList = ExampleProjectWizardRegistry.getExampleProjectRegistry().getProjectWizardDefinitionList(this.wizardConfigElement.getAttribute("id"));
    }

    private void openFile(final IResource file) {
        if (file.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)file), (String)"org.eclipse.ui.browser.editor", (boolean)true);
                    }
                    catch (Exception e) {
                        Debug.POLICY.logError((Throwable)e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)activePage.getWorkbenchWindow());
        }
    }
}

