/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.services.ui.NewServiceModelWidget;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelWizardPage
extends MBSCustomPage {
    public static final String SERVICE_MODEL_WIZARD_PAGE_ID = "org.eclipse.ptp.rdt.ui.serviceModelWizardPage";
    public static final String DEFAULT_CONFIG = Messages.getString("ConfigureRemoteServices.0");
    public static final String SERVICE_MODEL_WIDGET_PROPERTY = "org.eclipse.ptp.rdt.ui.ServiceModelWizardPage.serviceModelWidget";
    boolean fbVisited;
    private String fTitle;
    private String fDescription;
    private ImageDescriptor fImageDescriptor;
    private Image fImage;
    private Control fCanvas;
    private IServiceConfiguration fConfig;
    private NewServiceModelWidget fModelWidget;

    public ServiceModelWizardPage(String pageID) {
        super(pageID);
    }

    protected Set<IService> getContributedServices() {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        Set cppServices = smm.getServices("org.eclipse.cdt.core.ccnature");
        Set cServices = smm.getServices("org.eclipse.cdt.core.cnature");
        LinkedHashSet<IService> allApplicableServices = new LinkedHashSet<IService>();
        allApplicableServices.addAll(cppServices);
        allApplicableServices.addAll(cServices);
        return allApplicableServices;
    }

    public ServiceModelWizardPage() {
        this(SERVICE_MODEL_WIZARD_PAGE_ID);
    }

    protected boolean isCustomPageComplete() {
        return this.fbVisited;
    }

    public String getName() {
        return Messages.getString("ServiceModelWizardPage_0");
    }

    public void createControl(Composite parent) {
        this.fCanvas = parent;
        this.fModelWidget = new NewServiceModelWidget(parent, 0);
        MBSCustomPageManager.addPageProperty((String)this.pageID, (String)SERVICE_MODEL_WIDGET_PROPERTY, (Object)this.fModelWidget);
        String configName = DEFAULT_CONFIG;
        IWizardPage page = this.getWizard().getStartingPage();
        if (page instanceof CDTMainWizardPage) {
            CDTMainWizardPage cdtPage = (CDTMainWizardPage)page;
            configName = cdtPage.getProjectName();
        }
        this.fConfig = ServiceModelManager.getInstance().newServiceConfiguration(configName);
        for (IService service : this.getContributedServices()) {
            this.fConfig.setServiceProvider(service, null);
        }
        this.fModelWidget.setServiceConfiguration(this.fConfig);
        Shell control = this.fModelWidget.getParent().getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.ptp.rdt.ui.service_model_wizard_context");
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.fModelWidget;
    }

    public String getDescription() {
        if (this.fDescription == null) {
            this.fDescription = Messages.getString("ServiceModelWizardPage_description");
        }
        return this.fDescription;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        if (this.fImage == null && this.fImageDescriptor != null) {
            this.fImage = this.fImageDescriptor.createImage();
        }
        if (this.fImage == null && this.wizard != null) {
            this.fImage = this.wizard.getDefaultPageImage();
        }
        return this.fImage;
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        if (this.fTitle == null) {
            this.fTitle = Messages.getString("ServiceModelWizardPage_0");
        }
        return this.fTitle;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setImageDescriptor(ImageDescriptor image) {
        this.fImageDescriptor = image;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fbVisited = true;
        }
        this.fCanvas.setVisible(visible);
    }
}

