/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau.papiselect.papic;

import java.util.Stack;
import org.eclipse.ptp.perf.tau.papiselect.papic.Component;
import org.eclipse.ptp.perf.tau.papiselect.papic.Event;
import org.eclipse.ptp.perf.tau.papiselect.papic.EventSet;
import org.eclipse.ptp.perf.tau.papiselect.papic.EventTree;
import org.eclipse.ptp.perf.tau.papiselect.papic.Modifier;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PapiInfoParser
extends DefaultHandler {
    private static final String eventinfo = "eventinfo";
    private static final String component = "component";
    private static final String eventset = "eventset";
    private static final String event = "event";
    private static final String modifier = "modifier";
    private static final String index = "index";
    private static final String type = "type";
    private static final String id = "id";
    private static final String name = "name";
    private static final String desc = "desc";
    private static final String code = "code";
    private Stack<String> tagStack = new Stack();
    private EventTree et;
    private Component curComp;
    private EventSet curESet;
    private Event curEvent;

    public EventTree getEventTree() {
        return this.et;
    }

    public void reset() {
        this.et = null;
        this.curComp = null;
        this.curESet = null;
        this.curEvent = null;
    }

    private static String getAttribute(String name, Attributes atts) {
        int repdex = atts.getIndex(name);
        if (repdex >= 0) {
            return atts.getValue(repdex);
        }
        return null;
    }

    private static int getIntAttribute(String name, Attributes atts) {
        String str = PapiInfoParser.getAttribute(name, atts);
        if (str == null) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    public void startElement(String uri, String localName, String eName, Attributes atts) throws SAXException {
        if ((eName = eName.toLowerCase()).equals(eventinfo)) {
            this.et = new EventTree();
        } else if (eName.equals(component)) {
            if (this.et == null) {
                return;
            }
            this.curComp = new Component(this.et, PapiInfoParser.getIntAttribute(index, atts), PapiInfoParser.getAttribute(type, atts), PapiInfoParser.getAttribute(id, atts));
            this.et.addChild(this.curComp);
        } else if (eName.equals(eventset)) {
            if (this.curComp == null) {
                return;
            }
            this.curESet = new EventSet(this.curComp, PapiInfoParser.getAttribute(type, atts));
            this.curComp.addChild(this.curESet);
        } else if (eName.equals(event)) {
            if (this.curESet == null) {
                return;
            }
            this.curEvent = new Event(this.curESet, PapiInfoParser.getIntAttribute(index, atts), PapiInfoParser.getAttribute(name, atts), PapiInfoParser.getAttribute(desc, atts), PapiInfoParser.getAttribute(code, atts));
            this.curESet.addChild(this.curEvent);
            this.curESet.fullSet.add(new Integer(this.curEvent.index));
        } else if (eName.equals(modifier)) {
            if (this.curEvent == null) {
                return;
            }
            this.curEvent.addChild(new Modifier(this.curEvent, PapiInfoParser.getAttribute(name, atts), PapiInfoParser.getAttribute(desc, atts), PapiInfoParser.getAttribute(code, atts)));
        }
        this.tagStack.push(eName.toLowerCase());
    }

    public void endElement(String uri, String localName, String eName) throws SAXException {
        if (!(eName = eName.toLowerCase()).equals(eventinfo)) {
            if (eName.equals(component)) {
                this.curComp = null;
            } else if (eName.equals(eventset)) {
                this.curESet = null;
            } else if (eName.equals(event)) {
                this.curEvent = null;
            }
        }
        this.tagStack.pop();
    }
}

