/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.Messages;
import org.eclipse.ptp.cell.simulator.core.AbstractSimulatorDelegate;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.cell.simulator.core.SimulatorOperationException;
import org.eclipse.ptp.cell.simulator.tools.ContentRetrieverTool;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

public class LocalSimulatorDelegate
extends AbstractSimulatorDelegate {
    public LocalSimulatorDelegate(ISimulatorParameters configuration) {
        super(configuration);
    }

    public String[] createCellSimEnvironment() throws SimulatorException {
        Map env = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        this.addDefaultVariables(env);
        String[] strings = this.toVariablesArray(env);
        return strings;
    }

    public Process createGenericProcess(String workDirectory, String[] cmdarray, String[] environment) throws SimulatorException {
        Runtime runtime = Runtime.getRuntime();
        File workDir = null;
        if (workDirectory != null) {
            workDir = new File(workDirectory);
        }
        try {
            Process process = runtime.exec(cmdarray, environment, workDir);
            return process;
        }
        catch (IOException e) {
            throw new SimulatorException(NLS.bind((String)Messages.LocalSimulatorDelegate_CreatingProcessError, (Object[])new String[]{new ArgumentParser(cmdarray).getCommandLine(true), e.getMessage()}), (Throwable)e);
        }
    }

    public Process createSimulatorProcess(String workDirectory, String[] cmdarray, String[] environment) throws SimulatorException {
        ProcessFactory factory = ProcessFactory.getFactory();
        File workDir = null;
        if (workDirectory != null) {
            workDir = new File(workDirectory);
        }
        try {
            Process simulatorProcess = factory.exec(cmdarray, environment, workDir);
            if (!(simulatorProcess instanceof Spawner)) {
                throw new SimulatorException(Messages.LocalSimulatorDelegate_SpawingPOSIXProcessProblem);
            }
            return simulatorProcess;
        }
        catch (IOException e) {
            throw new SimulatorException(NLS.bind((String)Messages.LocalSimulatorDelegate_CreatingProcessError, (Object[])new String[]{new ArgumentParser(cmdarray).getCommandLine(true), e.getMessage()}), (Throwable)e);
        }
    }

    public void stopSimulatorProcess(Process process) {
        Spawner simulatorProcess = (Spawner)process;
        simulatorProcess.terminate();
    }

    public void destroySimulatorProcess(Process simulatorProcess) {
        simulatorProcess.destroy();
    }

    public void writeFile(String path, InputStream contentInputStrean) throws SimulatorException {
        File file = new File(path);
        try {
            file.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(file);
            ContentRetrieverTool.copyStreamContent((OutputStream)outputStream, (InputStream)contentInputStrean);
            outputStream.close();
        }
        catch (Exception e) {
            throw new SimulatorException(NLS.bind((String)Messages.LocalSimulatorDelegate_CouldNotWrite, (Object)file.toString()), (Throwable)e);
        }
    }

    public void readFile(String path, OutputStream contentInputStrean) throws SimulatorException {
        File file = new File(path);
        try {
            FileInputStream inputStream = new FileInputStream(file);
            ContentRetrieverTool.copyStreamContent((OutputStream)contentInputStrean, (InputStream)inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            throw new SimulatorException(NLS.bind((String)Messages.LocalSimulatorDelegate_CouldNotRead, (Object)file.toString()), (Throwable)e);
        }
    }

    public void removeFile(String path) throws SimulatorException {
        File file = new File(path);
        try {
            LocalSimulatorDelegate.recursiveDeleteFile(file);
        }
        catch (Exception exception) {
            throw new SimulatorException(NLS.bind((String)Messages.LocalSimulatorDelegate_CouldNotRemove, (Object)file.toString()));
        }
    }

    private static void recursiveDeleteFile(File f) {
        Stack<File> s = new Stack<File>();
        s.add(f);
        while (!s.empty()) {
            File file = (File)s.pop();
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] l = file.listFiles();
                if (l.length == 0) {
                    file.delete();
                    continue;
                }
                s.push(file);
                s.addAll(Arrays.asList(l));
                continue;
            }
            file.delete();
        }
    }

    public void logError(String string) {
        ILog log = CellSimulatorTargetPlugin.getDefault().getLog();
        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, string, null);
        log.log((IStatus)status);
    }

    public void logError(String string, Exception e) {
        ILog log = CellSimulatorTargetPlugin.getDefault().getLog();
        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, string, (Throwable)e);
        log.log((IStatus)status);
    }

    public boolean fileExists(String logDirectory) {
        File file = new File(logDirectory);
        return file.exists();
    }

    public void recursiveCreateDirectory(String path) throws Exception {
        File dir = new File(path);
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new Exception(NLS.bind((String)Messages.LocalSimulatorDelegate_CreateLocalDirectoryFailed, (Object)path));
        }
    }

    public void verifyPath(int option, String path) throws Exception {
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new SimulatorOperationException(10001, path);
        }
        if (!file.exists()) {
            throw new SimulatorOperationException(10002, path);
        }
        if ((option & 2) != 0 && !file.isFile()) {
            throw new SimulatorOperationException(10003, path);
        }
        if ((option & 4) != 0 && !file.isDirectory()) {
            throw new SimulatorOperationException(10004, path);
        }
        if ((option & 8) != 0 && !file.canRead()) {
            throw new SimulatorOperationException(10005, path);
        }
        if ((option & 0x10) != 0 && !file.canWrite()) {
            throw new SimulatorOperationException(10006, path);
        }
    }
}

