/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ChildrenProviderManager;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetTypeExtension;
import org.eclipse.ptp.utils.core.extensionpoints.IProcessMemberVisitor;
import org.eclipse.ptp.utils.core.extensionpoints.ProcessExtensions;
import org.osgi.framework.BundleContext;

public class EnvironmentPlugin
extends Plugin {
    public static final String FILENAME = "environments.xml";
    public static final String EXT_CONTROLS_ID = "org.eclipse.ptp.remotetools.environment.core.remoteEnvironmentControlDelegate";
    private static final String ID = "org.eclipse.ptp.remotetools.environment.core";
    private static EnvironmentPlugin plugin;
    private TargetEnvironmentManager manager;
    private ChildrenProviderManager childrenProviderMgr;
    public static final String ATTR_CORE_ENVIRONMENTID = "core-environmentid";

    public EnvironmentPlugin() {
        plugin = this;
    }

    public Map getControls() {
        final HashMap controls = new HashMap();
        ProcessExtensions.process((String)EXT_CONTROLS_ID, (IProcessMemberVisitor)new IProcessMemberVisitor(){

            public Object process(IExtension extension, IConfigurationElement member) {
                Object mprovider;
                try {
                    mprovider = member.createExecutableExtension("class");
                    if (ITargetTypeExtension.class.isAssignableFrom(mprovider.getClass())) {
                        controls.put(member.getAttribute("name"), mprovider);
                    }
                }
                catch (CoreException coreException) {
                    mprovider = null;
                }
                return mprovider;
            }
        });
        return controls;
    }

    public TargetEnvironmentManager getTargetsManager() {
        if (this.manager == null) {
            this.manager = new TargetEnvironmentManager();
        }
        return this.manager;
    }

    public ChildrenProviderManager getChildrenProviderManager() {
        if (this.childrenProviderMgr == null) {
            this.childrenProviderMgr = new ChildrenProviderManager();
        }
        return this.childrenProviderMgr;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.manager.writeToFile();
        plugin = null;
    }

    public synchronized void destroyTypeElements(Class extensionClass) {
        List typeList = this.getTargetsManager().getTypeElements();
        for (TargetTypeElement typeElement : typeList) {
            if (!typeElement.getExtension().getClass().equals(extensionClass)) continue;
            List elemList = typeElement.getElements();
            for (TargetElement el : elemList) {
                try {
                    ITargetControl ctl = el.getControl();
                    ctl.destroy();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static EnvironmentPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return ID;
    }

    public String getEnvironmentUniqueID() {
        long envID = System.currentTimeMillis();
        return String.valueOf(envID);
    }
}

