/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;

public class TargetElement
implements ITargetElement {
    private TargetTypeElement type;
    private Map attributes;
    private String name;
    private String id;
    private ITargetControl control;
    private int status = 1;
    private boolean dirty = false;

    public TargetElement(TargetTypeElement type, String id) {
        this.type = type;
        this.id = id;
    }

    public TargetElement(TargetTypeElement type, String name, Map attrs, String id) {
        this(type, id);
        this.attributes = attrs;
        this.name = name;
        this.type = type;
    }

    public void update(Map attr) {
        try {
            ITargetControl ctrl = this.getControl();
            if (attr == null) {
                ctrl.updateConfiguration();
            } else {
                ctrl.updateConfiguration();
            }
            this.dirty = false;
        }
        catch (CoreException coreException) {
            this.dirty = true;
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
        if (this.getStatus() == 1) {
            this.update(attributes);
        } else {
            this.dirty = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ITargetControl getControl() throws CoreException {
        if (this.control == null) {
            this.control = this.type.getExtension().controlFactory(this);
        }
        return this.control;
    }

    public void setControl(ITargetControl control) {
        this.control = control;
    }

    public TargetTypeElement getType() {
        return this.type;
    }

    public void setType(TargetTypeElement type) {
        this.type = type;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (status == 1 && this.dirty) {
            this.update(this.getAttributes());
        }
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }

    public String getId() {
        return this.id;
    }
}

