/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.cell.preferences.events.CellPreferencesChangeEvent;
import org.eclipse.ptp.cell.preferences.events.ICellPreferencesChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PreferencesPlugin
extends AbstractUIPlugin {
    private static PreferencesPlugin plugin;
    private List propertiesListeners;
    private Preferences.IPropertyChangeListener propertyListener;

    public PreferencesPlugin() {
        plugin = this;
        this.propertiesListeners = new ArrayList();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.propertyListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                PreferencesPlugin.this.fireValueChanged(event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        };
        this.getPluginPreferences().addPropertyChangeListener(this.propertyListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPluginPreferences().removePropertyChangeListener(this.propertyListener);
        this.savePluginPreferences();
        plugin = null;
    }

    public static PreferencesPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ptp.cell.preferences", (String)path);
    }

    public void addListener(ICellPreferencesChangeListener listener) {
        this.propertiesListeners.add(listener);
    }

    public void removeListener(ICellPreferencesChangeListener listener) {
        this.propertiesListeners.remove(listener);
    }

    public void fireValueChanged(String property, Object oldValue, Object newValue) {
        if (this.propertiesListeners.size() == 0) {
            return;
        }
        for (ICellPreferencesChangeListener listener : this.propertiesListeners) {
            listener.propertyChange(new CellPreferencesChangeEvent((Object)this, property, oldValue, newValue));
        }
    }
}

