/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.preferences.core;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.cell.preferences.core.SearcherMessages;
import org.eclipse.ptp.cell.utils.searcher.SearchFailedException;
import org.eclipse.ptp.cell.utils.searcher.Searcher;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class StringFieldEditorPreferenceSearcher
implements Searcher {
    protected StringFieldEditor stringFieldEditor;
    protected Text textControl;
    protected Display display;
    protected IPreferenceStore preferenceStore;
    protected String preferenceName;
    protected ListenerList propertyListeners;

    public StringFieldEditorPreferenceSearcher(StringFieldEditor stringFieldEditor, Composite parent) {
        this.stringFieldEditor = stringFieldEditor;
        this.textControl = stringFieldEditor.getTextControl(parent);
        this.display = this.textControl.getDisplay();
        this.preferenceStore = stringFieldEditor.getPreferenceStore();
        this.preferenceName = stringFieldEditor.getPreferenceName();
        this.propertyListeners = new ListenerList();
    }

    public void search() {
        block2: {
            try {
                this.fastSearch();
            }
            catch (SearchFailedException searchFailedException) {
                if (!this.wantLongSearch()) break block2;
                this.longSearch();
            }
        }
    }

    protected abstract void fastSearch() throws SearchFailedException;

    protected abstract void longSearch();

    protected boolean wantLongSearch() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return MessageDialog.openConfirm((Shell)shell, (String)SearcherMessages.longSearchConfirmationDialogTitle, (String)SearcherMessages.longSearchConfirmationDialogMessage);
    }

    protected void setText(final String newValue) {
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (!StringFieldEditorPreferenceSearcher.this.textControl.isDisposed()) {
                        String oldValue = StringFieldEditorPreferenceSearcher.this.stringFieldEditor.getStringValue();
                        StringFieldEditorPreferenceSearcher.this.stringFieldEditor.setStringValue(newValue);
                        StringFieldEditorPreferenceSearcher.this.firePropertyChangeEvent(StringFieldEditorPreferenceSearcher.this.preferenceName, oldValue, newValue);
                    } else {
                        String oldValue = StringFieldEditorPreferenceSearcher.this.preferenceStore.getString(StringFieldEditorPreferenceSearcher.this.preferenceName);
                        StringFieldEditorPreferenceSearcher.this.preferenceStore.setValue(StringFieldEditorPreferenceSearcher.this.preferenceName, newValue);
                        StringFieldEditorPreferenceSearcher.this.firePropertyChangeEvent(StringFieldEditorPreferenceSearcher.this.preferenceName, oldValue, newValue);
                    }
                }
            });
        } else {
            String oldValue = this.preferenceStore.getString(this.preferenceName);
            this.preferenceStore.setValue(this.preferenceName, newValue);
            this.firePropertyChangeEvent(this.preferenceName, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    protected void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Object[] changeListeners = this.propertyListeners.getListeners();
        if (changeListeners.length == 0) {
            return;
        }
        final PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        int i = 0;
        while (i < changeListeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)changeListeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.propertyChange(pe);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    protected void showInfoMessage(final String title, final String message) {
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)StringFieldEditorPreferenceSearcher.this.display.getActiveShell(), (String)title, (String)message);
                }
            });
            return;
        }
        MessageDialog.openInformation(null, (String)title, (String)message);
    }
}

