/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ptp.cell.simulator.conf.AttributeNames;
import org.eclipse.ptp.cell.simulator.conf.Parameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.simulator.core.Messages;

public abstract class AbstractSimulatorConfiguration
implements ISimulatorParameters {
    String simulatorBaseDirectory = null;
    String workDirectory = null;
    String architectureTclString = null;
    int memorySize = 0;
    String kernelImagePath = null;
    String rootImagePath = null;
    int rootImagePersistence = 0;
    String rootImageJournalPath = null;
    String extraImagePath = null;
    int extraImagePersistence = 0;
    String extraImageJournalPath = null;
    String extraImageMountPoint = null;
    String extraImageType = null;
    public static final String FS_EXT2 = "ext2";
    public static final String FS_ISO9660 = "iso9660";
    boolean networkInit = false;
    boolean sshInit = false;
    String ipHost = null;
    String ipSimulator = null;
    String macSimulator = null;
    String netmaskSimulator = null;
    boolean consoleTerminalInit = false;
    boolean consoleSocketInit = false;
    int consolePort = 4000;
    int consoleSocketPort = 4000;
    String consoleSocketHost = null;
    int consoleSocketPortMaxTries = 10;
    int consoleSocketPortTryWait = 1000;
    boolean javaApiSocketInit = false;
    int javaApiPort = 4001;
    int javaApiSocketPort = 4001;
    String javaApiSocketHost = null;
    int javaApiSocketPortMaxTries = 10;
    int javaApiSocketPortTryWait = 1000;
    URL tclScriptSource = null;
    String tclScriptName = null;
    URL[] deployFileSources = null;
    String[] deployFileNames = null;
    boolean showSimulatorGUI = true;
    String extraCommandLineSwitches;
    boolean consoleEcho = true;
    String consoleCommands = null;

    protected AbstractSimulatorConfiguration() {
    }

    private String createNewString(String s) {
        if (s == null) {
            return null;
        }
        return new String(s);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractSimulatorConfiguration other = (AbstractSimulatorConfiguration)super.clone();
        other.workDirectory = this.createNewString(this.workDirectory);
        other.simulatorBaseDirectory = this.createNewString(this.simulatorBaseDirectory);
        other.architectureTclString = this.createNewString(this.architectureTclString);
        other.kernelImagePath = this.createNewString(this.kernelImagePath);
        other.rootImagePath = this.createNewString(this.rootImagePath);
        other.rootImageJournalPath = this.createNewString(this.rootImageJournalPath);
        other.extraImagePath = this.createNewString(this.extraImagePath);
        other.extraImageJournalPath = this.createNewString(this.extraImagePath);
        other.extraImageMountPoint = this.createNewString(this.extraImageMountPoint);
        other.extraImageType = this.createNewString(this.extraImageType);
        other.ipHost = this.createNewString(this.ipHost);
        other.ipSimulator = this.createNewString(this.ipSimulator);
        other.macSimulator = this.createNewString(this.macSimulator);
        other.netmaskSimulator = this.createNewString(this.netmaskSimulator);
        other.extraCommandLineSwitches = this.createNewString(this.extraCommandLineSwitches);
        other.consoleCommands = this.createNewString(this.consoleCommands);
        try {
            other.tclScriptSource = this.tclScriptSource != null ? new URL(this.tclScriptSource.toString()) : null;
        }
        catch (MalformedURLException malformedURLException) {
            other.tclScriptSource = null;
        }
        other.tclScriptName = this.createNewString(this.tclScriptName);
        other.deployFileSources = new URL[this.deployFileSources.length];
        other.deployFileNames = new String[this.deployFileNames.length];
        int i = 0;
        while (i < this.deployFileSources.length) {
            try {
                if (this.deployFileSources != null) {
                    other.deployFileSources[i] = new URL(this.deployFileSources[i].toString());
                } else {
                    other.deployFileSources = null;
                }
                other.deployFileNames[i] = this.createNewString(this.deployFileNames[i]);
            }
            catch (MalformedURLException malformedURLException) {
                other.deployFileSources[i] = null;
                other.deployFileNames[i] = null;
            }
            ++i;
        }
        return other;
    }

    public void verify() throws IllegalConfigurationException {
    }

    public String getArchitectureTclString() {
        return this.architectureTclString;
    }

    public void setArchitectureTclString(String architectureTclString) {
        this.architectureTclString = architectureTclString;
    }

    public boolean doConsoleEcho() {
        return this.consoleEcho;
    }

    public void setConsoleEcho(boolean consoleEcho) {
        this.consoleEcho = consoleEcho;
    }

    public String[] getDeployFileNames() {
        return this.deployFileNames;
    }

    public void setDeployFileNames(String[] deployFileNames) {
        this.deployFileNames = deployFileNames;
    }

    public URL[] getDeployFileSources() {
        return this.deployFileSources;
    }

    public void setDeployFileSources(URL[] deployFileSources) {
        this.deployFileSources = deployFileSources;
    }

    public String getExtraCommandLineSwitches() {
        return this.extraCommandLineSwitches;
    }

    public void setExtraCommandLineSwitches(String extraCommandLineSwitches) {
        this.extraCommandLineSwitches = extraCommandLineSwitches;
    }

    public String getExtraImageJournalPath() {
        return this.extraImageJournalPath;
    }

    public void setExtraImageJournalPath(String extraImageJournalPath) {
        this.extraImageJournalPath = extraImageJournalPath;
    }

    public String getExtraImagePath() {
        return this.extraImagePath;
    }

    public void setExtraImagePath(String extraImagePath) {
        this.extraImagePath = extraImagePath;
    }

    public int getExtraImagePersistence() {
        return this.extraImagePersistence;
    }

    public void setExtraImagePersistence(int extraImagePersistence) {
        this.extraImagePersistence = extraImagePersistence;
    }

    public String getExtraImageType() {
        return this.extraImageType;
    }

    public void setExtraImageType(String extraImageType) {
        this.extraImageType = extraImageType;
    }

    public String getExtraImageMountPoint() {
        return this.extraImageMountPoint;
    }

    public void setExtraImageMountPoint(String extraImageMountPoint) {
        this.extraImageMountPoint = extraImageMountPoint;
    }

    public String getIpHost() {
        return this.ipHost;
    }

    public void setIpHost(String ipHost) {
        this.ipHost = ipHost;
    }

    public String getIpSimulator() {
        return this.ipSimulator;
    }

    public void setIpSimulator(String ipSimulator) {
        this.ipSimulator = ipSimulator;
    }

    public void setNetmaskSimulator(String netmask) {
        this.netmaskSimulator = netmask;
    }

    public String getNetmaskSimulator() {
        return this.netmaskSimulator;
    }

    public boolean doJavaApiSocketInit() {
        return this.javaApiSocketInit;
    }

    public void setJavaApiSocketInit(boolean javaApiSocketInit) {
        this.javaApiSocketInit = javaApiSocketInit;
    }

    public int getJavaApiPort() {
        return this.javaApiPort;
    }

    public void setJavaApiPort(int javaApiPort) {
        this.javaApiPort = javaApiPort;
    }

    public int getJavaApiSocketPort() {
        return this.javaApiSocketPort;
    }

    public void setJavaApiSocketPort(int javaApiSocketPort) {
        this.javaApiSocketPort = javaApiSocketPort;
    }

    public int getJavaApiSocketPortMaxTries() {
        return this.javaApiSocketPortMaxTries;
    }

    public void setJavaApiSocketPortMaxTries(int javaApiSocketPortMaxTries) {
        this.javaApiSocketPortMaxTries = javaApiSocketPortMaxTries;
    }

    public int getJavaApiSocketPortTryWait() {
        return this.javaApiSocketPortTryWait;
    }

    public void setJavaApiSocketPortTryWait(int javaApiSocketPortTryWait) {
        this.javaApiSocketPortTryWait = javaApiSocketPortTryWait;
    }

    public String getKernelImagePath() {
        return this.kernelImagePath;
    }

    public void setKernelImagePath(String kernelImagePath) {
        this.kernelImagePath = kernelImagePath;
    }

    public boolean doConsoleSocketInit() {
        return this.consoleSocketInit;
    }

    public void setConsoleSocketInit(boolean consoleSocketInit) {
        this.consoleSocketInit = consoleSocketInit;
    }

    public int getConsolePort() {
        return this.consolePort;
    }

    public void setConsolePort(int consolePort) {
        this.consolePort = consolePort;
    }

    public int getConsoleSocketPort() {
        return this.consoleSocketPort;
    }

    public void setConsoleSocketPort(int consoleSocketPort) {
        this.consoleSocketPort = consoleSocketPort;
    }

    public int getConsoleSocketPortMaxTries() {
        return this.consoleSocketPortMaxTries;
    }

    public void setConsoleSocketPortMaxTries(int consoleSocketPortMaxTries) {
        this.consoleSocketPortMaxTries = consoleSocketPortMaxTries;
    }

    public int getConsoleSocketPortTryWait() {
        return this.consoleSocketPortTryWait;
    }

    public void setConsoleSocketPortTryWait(int consoleSocketPortTryWait) {
        this.consoleSocketPortTryWait = consoleSocketPortTryWait;
    }

    public boolean doConsoleTerminalInit() {
        return this.consoleTerminalInit;
    }

    public void setConsoleTerminalInit(boolean consoleTerminalInit) {
        this.consoleTerminalInit = consoleTerminalInit;
    }

    public String getMacSimulator() {
        return this.macSimulator;
    }

    public void setMacSimulator(String macSimulator) {
        this.macSimulator = macSimulator;
    }

    public boolean doMemorySize() {
        return this.memorySize != 0;
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(int memorySize) {
        this.memorySize = memorySize;
    }

    public boolean doMountExtraImage() {
        return this.extraImagePath != null;
    }

    public boolean doNetworkInit() {
        return this.networkInit;
    }

    public void setNetworkInit(boolean networkInit) {
        this.networkInit = networkInit;
    }

    public String getRootImageJournalPath() {
        return this.rootImageJournalPath;
    }

    public void setRootImageJournalPath(String rootImageJournalPath) {
        this.rootImageJournalPath = rootImageJournalPath;
    }

    public String getRootImagePath() {
        return this.rootImagePath;
    }

    public void setRootImagePath(String rootImagePath) {
        this.rootImagePath = rootImagePath;
    }

    public int getRootImagePersistence() {
        return this.rootImagePersistence;
    }

    public void setRootImagePersistence(int rootImagePersistence) {
        this.rootImagePersistence = rootImagePersistence;
    }

    public boolean doShowSimulatorGUI() {
        return this.showSimulatorGUI;
    }

    public void setShowSimulatorGUI(boolean showSimulatorGUI) {
        this.showSimulatorGUI = showSimulatorGUI;
    }

    public String getSimulatorBaseDirectory() {
        return this.simulatorBaseDirectory;
    }

    public void setSimulatorBaseDirectory(String simulatorBaseDirectory) {
        this.simulatorBaseDirectory = simulatorBaseDirectory;
    }

    public boolean doSshInit() {
        return this.sshInit;
    }

    public void setSshInit(boolean sshInit) {
        this.sshInit = sshInit;
    }

    public String getTclScriptName() {
        return this.tclScriptName;
    }

    public void setTclScriptName(String tclScriptName) {
        this.tclScriptName = tclScriptName;
    }

    public URL getTclScriptSource() {
        return this.tclScriptSource;
    }

    public void setTclScriptSource(URL tclScriptSource) {
        this.tclScriptSource = tclScriptSource;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public String getConsoleSocketHost() {
        return this.consoleSocketHost;
    }

    public void setConsoleSocketHost(String consoleSocketHost) {
        this.consoleSocketHost = consoleSocketHost;
    }

    public String getJavaApiSocketHost() {
        return this.javaApiSocketHost;
    }

    public void setJavaApiSocketHost(String javaApiSocketHost) {
        this.javaApiSocketHost = javaApiSocketHost;
    }

    public String getConsoleCommands() {
        return this.consoleCommands;
    }

    public void setConsoleCommands(String consoleCommands) {
        this.consoleCommands = consoleCommands;
    }

    public String toString() {
        String r = "";
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_SimulatorParameters + this.getClass().getName() + "\n";
        r = String.valueOf(r) + AttributeNames.LAUNCH_DELEGATE + ": " + this.getDelegate().getClass().getName() + "\n";
        r = String.valueOf(r) + AttributeNames.SIMULATOR_BASE_DIRECTORY + ": " + this.simulatorBaseDirectory + "\n";
        r = String.valueOf(r) + AttributeNames.SIMULATOR_EXECUTABLE + ": " + this.getSimulatorExecutable() + "\n";
        r = String.valueOf(r) + AttributeNames.SNIF_EXECUTABLE + ": " + this.getSnifExecutable() + "\n";
        r = String.valueOf(r) + AttributeNames.WORK_DIRECTORY + ": " + this.workDirectory + "\n";
        r = String.valueOf(r) + AttributeNames.LOG_PATH + ": " + this.getLogDirectory() + "\n";
        r = String.valueOf(r) + AttributeNames.TAP_PATH + ": " + this.getTapDevicePath() + "\n";
        r = String.valueOf(r) + AttributeNames.ARCHITECTURE_TCL_STRING + ": " + this.architectureTclString.replace('\n', ';') + "\n";
        r = String.valueOf(r) + AttributeNames.MEMORY_SIZE + ": " + this.memorySize + "\n";
        r = String.valueOf(r) + AttributeNames.DEPLOY_FILE_NAMES + ": " + this.deployFileNames + "\n";
        r = String.valueOf(r) + AttributeNames.DEPLOY_FILE_SOURCES + ": " + this.deployFileSources + "\n";
        r = String.valueOf(r) + AttributeNames.TCL_SCRIPT_NAME + ": " + this.tclScriptName + "\n";
        r = String.valueOf(r) + AttributeNames.TCL_SOURCE_NAME + ": " + this.tclScriptSource + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_COMMAND_LINE_SWITCHES + ": " + this.extraCommandLineSwitches + "\n";
        r = String.valueOf(r) + AttributeNames.SSH_INIT + ": " + this.sshInit + "\n";
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_Network;
        r = String.valueOf(r) + AttributeNames.NETWORK_INIT + ": " + this.networkInit + "\n";
        r = String.valueOf(r) + AttributeNames.IP_HOST + ": " + this.ipHost + "\n";
        r = String.valueOf(r) + AttributeNames.IP_SIMULATOR + ": " + this.ipSimulator + "\n";
        r = String.valueOf(r) + AttributeNames.MAC_SIMULATOR + ": " + this.macSimulator + "\n";
        r = String.valueOf(r) + AttributeNames.NETMASK_SIMULATOR + ": " + this.netmaskSimulator + "\n";
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_FileSystem;
        r = String.valueOf(r) + AttributeNames.KERNEL_IMAGE_PATH + ": " + this.kernelImagePath + "\n";
        r = String.valueOf(r) + AttributeNames.ROOT_IMAGE_PATH + ": " + this.rootImagePath + "\n";
        r = String.valueOf(r) + AttributeNames.ROOT_IMAGE_PERSISTENCE + ": " + this.rootImagePersistence + "\n";
        r = String.valueOf(r) + AttributeNames.ROOT_IMAGE_JOURNAL_PATH + ": " + this.rootImageJournalPath + "\n";
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_JavaAPI;
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_JavaAPIQuestion + Parameters.doUseJavaAPI() + "\n";
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_JavaAPIGUIQuestion + Parameters.doHandleJavaApiGuiIssue() + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_IMAGE_INIT + ": " + this.doMountExtraImage() + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_IMAGE_PATH + ": " + this.extraImagePath + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_IMAGE_PERSISTENCE + ": " + this.extraImagePersistence + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_IMAGE_JOURNAL_PATH + ": " + this.extraImagePath + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_IMAGE_TYPE + ": " + this.extraImageType + "\n";
        r = String.valueOf(r) + AttributeNames.EXTRA_IMAGE_MOUNTPOINT + ": " + this.extraImageMountPoint + "\n";
        r = String.valueOf(r) + AttributeNames.JAVA_API_INIT + ": " + this.javaApiSocketInit + "\n";
        r = String.valueOf(r) + AttributeNames.JAVA_API_PORT + ": " + this.javaApiPort + "\n";
        r = String.valueOf(r) + AttributeNames.JAVA_API_SOCKET_PORT + ": " + this.javaApiSocketPort + "\n";
        r = String.valueOf(r) + AttributeNames.JAVA_API_SOCKET_HOST + ": " + this.javaApiSocketHost + "\n";
        r = String.valueOf(r) + AttributeNames.JAVA_API_SOCKET_MAX_TRIES + ": " + this.javaApiSocketPortMaxTries + "\n";
        r = String.valueOf(r) + AttributeNames.JAVA_API_SOCKET_TRY_WAIT + ": " + this.javaApiSocketPortTryWait + "\n";
        r = String.valueOf(r) + Messages.AbstractSimulatorConfiguration_LinuxConsole;
        r = String.valueOf(r) + AttributeNames.CONSOLE_TERMINAL_INIT + ": " + this.consoleTerminalInit + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_ECHO_INIT + ": " + this.consoleEcho + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_SOCKET_INIT + ": " + this.consoleSocketInit + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_PORT + ": " + this.consolePort + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_SOCKET_PORT + ": " + this.consoleSocketPort + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_SOCKET_HOST + ": " + this.consoleSocketHost + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_SOCKET_MAX_TRIES + ": " + this.consoleSocketPortMaxTries + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_SOCKET_TRY_WAIT + ": " + this.consoleSocketPortTryWait + "\n";
        r = String.valueOf(r) + AttributeNames.CONSOLE_COMMANDS + ": " + this.consoleCommands + "\n";
        r = String.valueOf(r) + AttributeNames.SHOW_SIMULATOR_GUI + ": " + this.showSimulatorGUI + "\n";
        return r;
    }
}

